/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.kubernetes.client.HttpException;
import com.predic8.membrane.core.kubernetes.client.KubernetesApiException;
import com.predic8.membrane.core.kubernetes.client.Schema;
import com.predic8.membrane.core.kubernetes.client.WatchAction;
import com.predic8.membrane.core.kubernetes.client.Watcher;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.functionalInterfaces.ExceptionThrowingConsumer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bouncycastle.util.Arrays;

public class KubernetesClient {
    private final ExceptionThrowingConsumer<Exchange> client;
    private final String baseURL;
    private final String namespace;
    private final Schema schema;
    private final ObjectMapper om;

    KubernetesClient(ExceptionThrowingConsumer<Exchange> client, String baseURL, String namespace) {
        this.client = client;
        this.baseURL = baseURL;
        this.namespace = namespace == null ? "default" : namespace;
        this.om = new ObjectMapper();
        try {
            this.schema = Schema.getSchema(this, this.om);
        }
        catch (HttpException | IOException e) {
            throw new RuntimeException("could not initialize schema", e);
        }
    }

    public Map version() throws HttpException, IOException {
        Exchange e;
        try {
            e = new Request.Builder().get(this.baseURL + "/version").buildExchange();
            this.client.accept(e);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (e.getResponse().getStatusCode() != 200) {
            throw new HttpException(e.getResponse().getStatusCode(), e.getResponse().getStatusMessage() + " " + e.getResponse().getBodyAsStringDecoded());
        }
        return (Map)this.om.readValue(e.getResponse().getBodyAsStringDecoded(), Map.class);
    }

    public ExceptionThrowingConsumer<Exchange> getClient() {
        return this.client;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Stream<Map> listItems(String apiVersion, String kind, String namespace, int batchSize) throws IOException, KubernetesApiException {
        return this.list(apiVersion, kind, namespace, batchSize).flatMap(map -> ((List)map.get("items")).stream());
    }

    public Stream<Map> list(String apiVersion, String kind, String namespace, final int batchSize) throws IOException, KubernetesApiException {
        final String path = this.getPath("list", apiVersion, kind, namespace, null);
        Spliterator<Map> spliterator = new Spliterator<Map>(){
            boolean first = true;
            String _continue = null;

            @Override
            public boolean tryAdvance(Consumer<? super Map> action) {
                if (!this.first && this._continue == null) {
                    return false;
                }
                try {
                    Exchange e = new Request.Builder().get(KubernetesClient.this.baseURL + path + "?limit=" + batchSize + (String)(this._continue != null ? "&continue=" + this._continue : "")).buildExchange();
                    KubernetesClient.this.doCall(new int[]{200}, e);
                    Map map = (Map)KubernetesClient.this.om.readValue(e.getResponse().getBodyAsStringDecoded(), Map.class);
                    this.first = false;
                    this._continue = (String)((Map)map.get("metadata")).get("continue");
                    action.accept(map);
                    return true;
                }
                catch (KubernetesApiException | IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Spliterator<Map> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 1281;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public Closeable watch(String apiVersion, String kind, String namespace, Long resourceVersion, ExecutorService executors, Watcher watcher) throws IOException, KubernetesApiException {
        String path = this.getPath("list", apiVersion, kind, namespace, null);
        try {
            Exchange e = new Request.Builder().get(this.baseURL + path + "?watch=1" + (String)(resourceVersion != null ? "&resourceVersion=" + resourceVersion : "")).buildExchange();
            this.doCall(new int[]{200}, e, false);
            executors.submit(() -> {
                try (InputStream is = e.getResponse().getBodyAsStreamDecoded();){
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    while ((line = br.readLine()) != null) {
                        Map envelope = (Map)this.om.readValue(line, Map.class);
                        WatchAction action = WatchAction.valueOf((String)envelope.get("type"));
                        Map o = (Map)envelope.get("object");
                        watcher.onEvent(action, o);
                    }
                    watcher.onClosed(null);
                }
                catch (Throwable throwable) {
                    watcher.onClosed(throwable);
                }
            });
            return e.getTargetConnection();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map read(Map resource) throws IOException, KubernetesApiException {
        return this.read((String)resource.get("apiVersion"), (String)resource.get("kind"), (String)((Map)resource.get("metadata")).get("namespace"), (String)((Map)resource.get("metadata")).get("name"));
    }

    public Map read(String apiVersion, String kind, String namespace, String name) throws IOException, KubernetesApiException {
        String path = this.getPath("read", apiVersion, kind, namespace, name);
        try {
            Exchange e = new Request.Builder().get(this.baseURL + path).buildExchange();
            this.doCall(new int[]{200}, e);
            return (Map)this.om.readValue(e.getResponse().getBodyAsStringDecoded(), Map.class);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map create(Map resource) throws IOException, KubernetesApiException {
        String path = this.getPath("create", (String)resource.get("apiVersion"), (String)resource.get("kind"), (String)((Map)resource.get("metadata")).get("namespace"), null);
        String body = this.om.writeValueAsString((Object)resource);
        try {
            Exchange e = new Request.Builder().post(this.baseURL + path + "?fieldManager=membrane").header("Content-Type", "application/json;charset=utf-8").body(body).buildExchange();
            this.doCall(new int[]{201}, e);
            return (Map)this.om.readValue(e.getResponse().getBodyAsStringDecoded(), Map.class);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void delete(Map resource) throws IOException, KubernetesApiException {
        this.delete((String)resource.get("apiVersion"), (String)resource.get("kind"), (String)((Map)resource.get("metadata")).get("namespace"), (String)((Map)resource.get("metadata")).get("name"));
    }

    public void delete(String apiVersion, String kind, String namespace, String name) throws IOException, KubernetesApiException {
        String path = this.getPath("read", apiVersion, kind, namespace, name);
        try {
            this.doCall(new int[]{200}, new Request.Builder().delete(this.baseURL + path).buildExchange());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void patch(String apiVersion, String kind, String namespace, String name, String contentType, Object body) throws IOException, KubernetesApiException {
        String path = this.getPath("patch", apiVersion, kind, namespace, name);
        String bodyJ = this.om.writeValueAsString(body);
        try {
            this.doCall(new int[]{200}, new Request.Builder().header("Content-Type", contentType).url(new URIFactory(), this.baseURL + path).method("PATCH").body(bodyJ).buildExchange());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void apply(Map resource) throws IOException, KubernetesApiException {
        String path = this.getPath("patch", (String)resource.get("apiVersion"), (String)resource.get("kind"), (String)((Map)resource.get("metadata")).get("namespace"), (String)((Map)resource.get("metadata")).get("name"));
        String body = this.om.writeValueAsString((Object)resource);
        try {
            this.doCall(new int[]{200, 201}, new Request.Builder().url(new URIFactory(), this.baseURL + path + "?fieldManager=membrane&force=false").method("PATCH").header("Content-Type", "application/apply-patch+yaml").body(body).buildExchange());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void edit(Map resource, Consumer<Map> editor) throws IOException, KubernetesApiException {
        Map m = this.read(resource);
        editor.accept(m);
        ((Map)m.get("metadata")).remove("managedFields");
        this.apply(m);
    }

    public void edit(String apiVersion, String kind, String namespace, String name, Consumer<Map> editor) throws IOException, KubernetesApiException {
        Map m = this.read(apiVersion, kind, namespace, name);
        editor.accept(m);
        ((Map)m.get("metadata")).remove("managedFields");
        this.apply(m);
    }

    public void createAndEdit(Map resource, Consumer<Map> editor) throws IOException, KubernetesApiException {
        Map m = null;
        while (m == null) {
            block5: {
                try {
                    m = this.read(resource);
                }
                catch (KubernetesApiException e) {
                    if (e.getCode() == 404 && "NotFound".equals(e.getReason())) break block5;
                    throw e;
                }
            }
            if (m != null) continue;
            try {
                m = this.create(resource);
                break;
            }
            catch (KubernetesApiException e) {
                if (e.getCode() == 409 && "AlreadyExists".equals(e.getReason())) continue;
                throw e;
            }
        }
        editor.accept(m);
        ((Map)m.get("metadata")).remove("managedFields");
        this.apply(m);
    }

    private String getPath(String verb, String apiVersion, String kind, String namespace, String name) {
        String path = this.schema.getPath(verb, apiVersion, kind, namespace == null);
        if (path.contains("{namespace}")) {
            if (namespace == null) {
                throw new IllegalArgumentException("The path " + path + " contains a namespace placeholder, but no namespace was provided.");
            }
            path = path.replaceAll("\\{namespace}", namespace);
        }
        if (path.contains("{name}")) {
            if (name == null) {
                throw new IllegalArgumentException("The path " + path + " contains a name placeholder, but no name was provided.");
            }
            path = path.replaceAll("\\{name}", name);
        }
        return path;
    }

    private void doCall(int[] expectedHttpCode, Exchange e) throws KubernetesApiException, IOException {
        this.doCall(expectedHttpCode, e, true);
    }

    private void doCall(int[] expectedHttpCode, Exchange e, boolean fullyReadBody) throws KubernetesApiException, IOException {
        try {
            this.client.accept(e);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (fullyReadBody) {
            e.getResponse().getBodyAsStreamDecoded();
        }
        if (Arrays.contains((int[])expectedHttpCode, (int)e.getResponse().getStatusCode())) {
            return;
        }
        Map rbody = (Map)this.om.readValue(e.getResponse().getBodyAsStreamDecoded(), Map.class);
        throw new KubernetesApiException(e.getResponse().getStatusCode(), rbody);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

