/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes.client;

import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientBuilder;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import java.util.WeakHashMap;

public class KubernetesClientFactory {
    private WeakHashMap<String, KubernetesClient> clients;
    private final HttpClientFactory httpClientFactory;

    public KubernetesClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public synchronized KubernetesClient createClient(String baseUrl) {
        KubernetesClient client;
        if (this.clients == null) {
            this.clients = new WeakHashMap();
        }
        if ((client = this.clients.get(baseUrl)) == null) {
            try {
                KubernetesClientBuilder builder = KubernetesClientBuilder.auto().httpClientFactory(this.httpClientFactory);
                if (baseUrl != null) {
                    builder.baseURL(baseUrl);
                }
                client = builder.build();
                this.clients.put(baseUrl, client);
            }
            catch (KubernetesClientBuilder.ParsingException e) {
                throw new RuntimeException(e);
            }
        }
        return client;
    }
}

