/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.lang.ScriptingUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractScriptInterceptor.class.getName());
    protected static final ObjectMapper om = new ObjectMapper();
    protected String src;
    protected Function<Map<String, Object>, Object> script;
    private boolean scriptAccessesJson;

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.runScript(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.runScript(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void init() {
        super.init();
        if (this.router == null) {
            throw new RuntimeException("ScriptInterceptors need router instance!");
        }
        if (this.src.isEmpty()) {
            throw new RuntimeException("Script must have a src!");
        }
        this.scriptAccessesJson = this.src.contains("json");
        this.initInternal();
    }

    protected abstract void initInternal();

    protected Outcome runScript(Exchange exc, Interceptor.Flow flow) {
        Object res;
        Message msg = AbstractScriptInterceptor.getMessage(exc, flow);
        try {
            res = this.script.apply(this.getParameterBindings(exc, flow, msg));
        }
        catch (Exception e) {
            this.handleScriptExecutionException(exc, e);
            return Outcome.ABORT;
        }
        if (res instanceof Outcome) {
            Outcome outcome = (Outcome)((Object)res);
            return outcome;
        }
        if (res instanceof Response) {
            Response response = (Response)res;
            exc.setResponse(response);
            return Outcome.RETURN;
        }
        if (res instanceof Request) {
            Request request = (Request)res;
            exc.setRequest(request);
        }
        if (res instanceof Map) {
            Map m = (Map)res;
            msg = AbstractScriptInterceptor.createResponseAndToExchangeIfThereIsNone(exc, flow, msg);
            msg.getHeader().setContentType("application/json");
            try {
                msg.setBodyContent(om.writeValueAsBytes((Object)m));
            }
            catch (JsonProcessingException e) {
                log.error("", (Throwable)e);
                ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("json-processing-1").detail("Error serializing Map to JSON").exception(e).buildAndSetResponse(exc);
                return Outcome.ABORT;
            }
            return Outcome.CONTINUE;
        }
        if (res instanceof String) {
            String s = (String)res;
            if (s.equals("undefined")) {
                return Outcome.CONTINUE;
            }
            msg = AbstractScriptInterceptor.createResponseAndToExchangeIfThereIsNone(exc, flow, msg);
            msg.getHeader().setContentType("text/html;charset=UTF-8");
            msg.setBodyContent(s.getBytes(StandardCharsets.UTF_8));
            return Outcome.CONTINUE;
        }
        if (res == null) {
            return Outcome.CONTINUE;
        }
        if (res.getClass().getPackageName().startsWith("org.graalvm.polyglot") && res instanceof Value) {
            Value value = (Value)res;
            Map m = (Map)value.as(Map.class);
            msg.getHeader().setContentType("application/json");
            try {
                msg.setBodyContent(om.writeValueAsBytes((Object)m));
            }
            catch (JsonProcessingException e) {
                log.error("", (Throwable)e);
                ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("json-processing-2").detail("Error serializing Map to JSON").exception(e).buildAndSetResponse(exc);
                return Outcome.ABORT;
            }
            return Outcome.CONTINUE;
        }
        return Outcome.CONTINUE;
    }

    @Nullable
    private static Message createResponseAndToExchangeIfThereIsNone(Exchange exchange, Interceptor.Flow flow, Message msg) {
        if (msg != null) {
            return msg;
        }
        if (flow.isResponse()) {
            Response response = Response.ok().build();
            exchange.setResponse(response);
            return response;
        }
        return null;
    }

    protected void handleScriptExecutionException(Exchange exc, Exception e) {
        log.warn("Error executing {} script: {}", (Object)this.name, (Object)e.getMessage());
        log.warn("Script: {}", (Object)this.src);
        ProblemDetails pd = ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("script-execution").title("Error executing script.");
        if (!this.router.isProduction()) {
            pd.internal("message", e.getMessage()).internal("source", StringUtils.trim((String)this.src));
        } else {
            pd.detail("See logs for details.");
        }
        exc.setResponse(pd.build());
    }

    private HashMap<String, Object> getParameterBindings(Exchange exc, Interceptor.Flow flow, Message msg) {
        HashMap<String, Object> binding = ScriptingUtils.createParameterBindings(this.router, exc, flow, this.scriptAccessesJson && msg.isJSON());
        this.addOutcomeObjects(binding);
        return binding;
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.runScript(exc, Interceptor.Flow.ABORT);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void addOutcomeObjects(HashMap<String, Object> parameters) {
        parameters.put("Outcome", Outcome.class);
        parameters.put("RETURN", (Object)Outcome.RETURN);
        parameters.put("CONTINUE", (Object)Outcome.CONTINUE);
        parameters.put("ABORT", (Object)Outcome.ABORT);
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }
}

