/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.lang.groovy.GroovyExchangeExpression;
import com.predic8.membrane.core.lang.jsonpath.JsonpathExchangeExpression;
import com.predic8.membrane.core.lang.spel.SpELExchangeExpression;
import com.predic8.membrane.core.lang.xpath.XPathExchangeExpression;

public interface ExchangeExpression {
    public String getExpression();

    public <T> T evaluate(Exchange var1, Interceptor.Flow var2, Class<T> var3) throws ExchangeExpressionException;

    public static ExchangeExpression newInstance(Router router, Language language, String expression) {
        return switch (language.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new GroovyExchangeExpression(router, expression);
            case 1 -> new SpELExchangeExpression(expression, null);
            case 2 -> new XPathExchangeExpression(expression);
            case 3 -> new JsonpathExchangeExpression(expression);
        };
    }

    public static enum Language {
        GROOVY,
        SPEL,
        XPATH,
        JSONPATH;

    }
}

