/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import java.util.HashMap;
import java.util.Map;

public class ExchangeExpressionException
extends RuntimeException {
    private final String expression;
    private final Map<String, Object> extensions = new HashMap<String, Object>();
    private boolean statcktrace = true;
    private String body;

    public ExchangeExpressionException(String expression, Throwable cause) {
        super(cause);
        this.expression = expression;
    }

    public ProblemDetails provideDetails(ProblemDetails pd) {
        pd.internal("expression", this.expression).stacktrace(this.statcktrace);
        for (Map.Entry<String, Object> entry : this.extensions.entrySet()) {
            pd.internal(entry.getKey(), entry.getValue());
        }
        if (this.body != null) {
            pd.internal("body", this.body.length() > 1024 ? this.body.substring(0, 1024) : this.body);
        }
        pd.exception(this);
        pd.stacktrace(false);
        return pd;
    }

    public ExchangeExpressionException extension(String key, Object value) {
        this.extensions.put(key, value);
        return this;
    }

    public ExchangeExpressionException line(String line) {
        this.extensions.put("line", line);
        return this;
    }

    public ExchangeExpressionException column(String column) {
        this.extensions.put("column", column);
        return this;
    }

    public ExchangeExpressionException stacktrace(boolean stacktrace) {
        this.statcktrace = stacktrace;
        return this;
    }

    public ExchangeExpressionException body(String body) {
        this.body = body;
        return this;
    }
}

