/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptExecutorPool<T, R>
implements Function<Map<String, Object>, R> {
    private static final Logger log = LoggerFactory.getLogger(ScriptExecutorPool.class);
    private static final int concurrency = Runtime.getRuntime().availableProcessors() * 2;
    ArrayBlockingQueue<T> scripts = new ArrayBlockingQueue(concurrency);

    public void init(ExecutorService executorService) {
        this.scripts.add(this.createOneScript());
        executorService.execute(() -> {
            try {
                for (int i = 1; i < concurrency; ++i) {
                    this.scripts.add(this.createOneScript());
                }
            }
            catch (Exception e) {
                log.error("Error compiling script:", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object execute(Map<String, Object> parameters) {
        Object object;
        T script = this.scripts.take();
        try {
            object = this.invoke(script, parameters);
        }
        catch (Throwable throwable) {
            try {
                this.scripts.put(script);
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.scripts.put(script);
        return object;
    }

    protected abstract Object invoke(T var1, Map<String, Object> var2);

    protected abstract T createOneScript();
}

