/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.groovy.PathParametersMap;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriTemplateMatcher;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.FileUtil;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingUtils {
    private static final Logger log = LoggerFactory.getLogger((String)ScriptingUtils.class.getName());
    private static final ObjectMapper om = new ObjectMapper();

    public static HashMap<String, Object> createParameterBindings(Router router, Exchange exc, Interceptor.Flow flow, boolean includeJsonObject) {
        Message msg = exc.getMessage(flow);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spring", router.getBeanFactory());
        params.put("exc", exc);
        params.put("exchange", exc);
        params.put("flow", (Object)flow);
        if (flow == Interceptor.Flow.REQUEST) {
            try {
                Map<String, String> qParams = URLParamUtil.getParams(router.getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.MERGE_USING_COMMA);
                params.put("params", qParams);
                params.put("param", qParams);
            }
            catch (Exception e) {
                log.info("Cannot parse query parameter from {}", (Object)exc.getRequest().getUri());
            }
        } else if (flow == Interceptor.Flow.RESPONSE) {
            Response response = exc.getResponse();
            params.put("response", response);
            params.put("statusCode", response.getStatusCode());
        }
        if (msg != null) {
            params.put("message", msg);
            params.put("header", msg.getHeader());
            params.put("headers", msg.getHeader());
            if (includeJsonObject) {
                try {
                    log.info("Parsing body as JSON for scripting plugins");
                    params.put("json", om.readValue(FileUtil.readInputStream(msg.getBodyAsStream()), Map.class));
                }
                catch (Exception e) {
                    log.warn("Can't parse body as JSON", (Throwable)e);
                }
            }
        }
        params.put("property", exc.getProperties());
        params.put("properties", exc.getProperties());
        params.put("props", exc.getProperties());
        params.put("pathParam", new PathParametersMap(exc));
        return params;
    }

    public static Map<String, String> extractPathParameters(Exchange exchange) {
        Proxy proxy = exchange.getProxy();
        if (!(proxy instanceof APIProxy)) {
            return Collections.emptyMap();
        }
        APIProxy ap = (APIProxy)proxy;
        try {
            return new HashMap<String, String>(UriTemplateMatcher.matchTemplate(ap.getPath().getValue(), exchange.getRequestURI()));
        }
        catch (PathDoesNotMatchException ignore) {
            log.info("No path parameters extracted: uriTemplate {}, path {}", (Object)ap.getPath().getValue(), (Object)exchange.getRequestURI());
            return Collections.emptyMap();
        }
    }
}

