/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.lang.spel.SpELExchangeExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateExchangeExpression
extends AbstractExchangeExpression {
    private static final Logger log = LoggerFactory.getLogger(TemplateExchangeExpression.class);
    private static final Pattern scriptPattern = Pattern.compile("([^$]+)?(\\$\\{(.*?)})?|");
    private final List<Token> tokens;

    public static ExchangeExpression newInstance(Router router, ExchangeExpression.Language language, String expression) {
        if (language == ExchangeExpression.Language.SPEL) {
            return new SpELExchangeExpression(expression, new SpELExchangeExpression.DollarBracketTemplateParserContext());
        }
        return new TemplateExchangeExpression(router, language, expression);
    }

    protected TemplateExchangeExpression(Router router, ExchangeExpression.Language language, String expression) {
        super(expression);
        this.tokens = TemplateExchangeExpression.parseTokens(router, language, expression);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
        if (this.tokens.isEmpty()) {
            return null;
        }
        if (this.tokens.size() == 1) {
            if (type.getName().equals(String.class.getName())) {
                return type.cast(this.evaluateToString(exchange, flow));
            }
            return type.cast(this.evaluateToObject(exchange, flow));
        }
        return type.cast(this.evaluateToString(exchange, flow));
    }

    private Object evaluateToObject(Exchange exchange, Interceptor.Flow flow) {
        try {
            return this.tokens.getFirst().eval(exchange, flow, Object.class);
        }
        catch (Exception e) {
            throw new ExchangeExpressionException(this.tokens.getFirst().toString(), e);
        }
    }

    private String evaluateToString(Exchange exchange, Interceptor.Flow flow) {
        StringBuilder line = new StringBuilder();
        for (Token token : this.tokens) {
            try {
                line.append(token.eval(exchange, flow, String.class));
            }
            catch (Exception e) {
                throw new ExchangeExpressionException(token.toString(), e);
            }
        }
        return line.toString();
    }

    protected static List<Token> parseTokens(Router router, ExchangeExpression.Language language, String expression) {
        log.debug("Parsing: {}", (Object)expression);
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher m = scriptPattern.matcher(expression);
        while (m.find()) {
            String expr;
            String text = m.group(1);
            if (text != null) {
                tokens.add(new Text(text));
            }
            if ((expr = m.group(3)) == null) continue;
            tokens.add(new Expression(ExchangeExpression.newInstance(router, language, expr)));
        }
        log.debug("Tokens: {}", tokens);
        return tokens;
    }

    static interface Token {
        public <T> T eval(Exchange var1, Interceptor.Flow var2, Class<T> var3);

        public String getExpression();
    }

    static class Text
    implements Token {
        private final String value;

        public Text(String value) {
            this.value = value;
        }

        @Override
        public <T> T eval(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
            return type.cast(this.value);
        }

        @Override
        public String getExpression() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return this.value.equals(t.value);
            }
            return false;
        }

        public String toString() {
            return "Text(%s)".formatted(this.value);
        }
    }

    static class Expression
    implements Token {
        private final ExchangeExpression exchangeExpression;

        public Expression(ExchangeExpression exchangeExpression) {
            this.exchangeExpression = exchangeExpression;
        }

        @Override
        public <T> T eval(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
            return this.exchangeExpression.evaluate(exchange, flow, type);
        }

        @Override
        public String getExpression() {
            return this.exchangeExpression.toString();
        }

        public String toString() {
            return "Expr(%s)".formatted(this.exchangeExpression);
        }
    }
}

