/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.groovy;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractExchangeExpression;
import com.predic8.membrane.core.lang.ScriptingUtils;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import com.predic8.membrane.core.util.ConfigurationException;
import groovy.lang.MissingPropertyException;
import java.util.Map;
import java.util.function.Function;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyExchangeExpression
extends AbstractExchangeExpression {
    private static final Logger log = LoggerFactory.getLogger(GroovyExchangeExpression.class);
    private final Function<Map<String, Object>, Object> script;
    private final Router router;

    public GroovyExchangeExpression(Router router, String source) {
        super(source);
        this.router = router;
        try {
            this.script = new GroovyLanguageSupport().compileScript(router.getBackgroundInitializer(), null, source);
        }
        catch (MultipleCompilationErrorsException e) {
            throw new ConfigurationException("Cannot compile Groovy Script.", e);
        }
    }

    @Override
    public <T> T evaluate(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
        Object o;
        block8: {
            o = null;
            try {
                o = this.script.apply(ScriptingUtils.createParameterBindings(this.router, exchange, flow, false));
            }
            catch (MissingPropertyException mpe) {
                log.info("Expression {} tries to access non existing property {}", (Object)this.expression, (Object)mpe.getMessage());
                if (type.getName().equals(Object.class.getName())) {
                    return null;
                }
                if (!type.isAssignableFrom(String.class)) break block8;
                return type.cast("");
            }
        }
        if (type.getName().equals(String.class.getName())) {
            if (o == null) {
                return type.cast("");
            }
            if (o instanceof Number) {
                Number n = (Number)o;
                return type.cast(String.valueOf(n));
            }
            if (type.isInstance(o)) {
                return type.cast(o);
            }
            return type.cast(o.toString());
        }
        if (o == null) {
            return null;
        }
        return type.cast(o);
    }
}

