/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.groovy;

import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class GroovyLanguageSupport
implements LanguageSupport {
    private static final GroovyShell shell = new GroovyShell();

    @Override
    public Function<Map<String, Object>, Object> compileScript(ExecutorService executorService, ClassLoader classLoader, String script) {
        return new GroovyScriptExecutorPool<Object>(this, executorService, this.addImports(script)){

            @Override
            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private String addImports(String src) {
        return "import static com.predic8.membrane.core.interceptor.Outcome.*\nimport com.predic8.membrane.core.http.*\n" + src;
    }

    private static abstract class GroovyScriptExecutorPool<R>
    extends ScriptExecutorPool<Script, R> {
        private final String groovyCode;

        private GroovyScriptExecutorPool(ExecutorService executorService, String expression) {
            this.groovyCode = expression;
            this.init(executorService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Script createOneScript() {
            GroovyShell groovyShell = shell;
            synchronized (groovyShell) {
                return shell.parse(this.groovyCode);
            }
        }

        @Override
        protected Object invoke(Script script, Map<String, Object> parameters) {
            script.setBinding(GroovyScriptExecutorPool.getBinding(parameters));
            return script.run();
        }

        private static Binding getBinding(Map<String, Object> parameters) {
            Binding b = new Binding();
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                b.setVariable(parameter.getKey(), parameter.getValue());
            }
            return b;
        }
    }
}

