/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.javascript;

import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import com.predic8.membrane.core.util.TextUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoJavascriptLanguageSupport
implements LanguageSupport {
    private static final Logger log = LoggerFactory.getLogger(RhinoJavascriptLanguageSupport.class);

    @Override
    public Function<Map<String, Object>, Object> compileScript(ExecutorService executorService, ClassLoader classLoader, String script) {
        return new JavascriptScriptExecutorPool<Object>(this, executorService, classLoader, script){

            @Override
            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private static abstract class JavascriptScriptExecutorPool<R>
    extends ScriptExecutorPool<ScriptEngine, R> {
        private final String javascriptCode;
        protected final ScriptEngineManager sce;
        protected static final String javascriptEngineName = "rhino";

        private JavascriptScriptExecutorPool(ExecutorService executorService, ClassLoader classLoader, String expression) {
            this.javascriptCode = expression;
            this.sce = new ScriptEngineManager(classLoader);
            this.init(executorService);
        }

        @Override
        protected Object invoke(ScriptEngine script, Map<String, Object> parameters) {
            parameters.forEach(script::put);
            try {
                return script.eval(this.javascriptCode);
            }
            catch (ScriptException e) {
                log.error("Error compiling script: {}", (Object)e.getMessage());
                log.error("Error in Line: {}", (Object)TextUtil.getLineFromMultilineString(this.javascriptCode, e.getLineNumber()));
                log.error("Script:\n{}", (Object)this.javascriptCode);
                throw new RuntimeException("Error compiling script:", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ScriptEngine createOneScript() {
            ScriptEngineManager scriptEngineManager = this.sce;
            synchronized (scriptEngineManager) {
                return this.sce.getEngineByName(javascriptEngineName);
            }
        }
    }
}

