/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.jsonpath;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jose4j.json.internal.json_simple.JSONAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonpathExchangeExpression
extends AbstractExchangeExpression {
    private static final Logger log = LoggerFactory.getLogger(JsonpathExchangeExpression.class);
    private final ObjectMapper om = new ObjectMapper();

    public JsonpathExchangeExpression(String source) {
        super(source);
        JsonpathExchangeExpression.syntaxCheckJsonpath(source);
    }

    private static void syntaxCheckJsonpath(String source) {
        try {
            JsonPath.read((InputStream)new ByteArrayInputStream("{}".getBytes()), (String)source, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (Exception e) {
            throw new ConfigurationException("The jsonpath expression:\n\n%s\n\ncannot be compiled.\n\nError: %s".formatted(source, e));
        }
    }

    @Override
    public <T> T evaluate(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
        try {
            if (exchange.getMessage(flow).isBodyEmpty() || !exchange.getMessage(flow).isJSON()) {
                log.debug("Body is empty or Content-Type not JSON. Nothing to evaluate for expression: {}", (Object)this.expression);
                return this.resultForNoEvaluation(type);
            }
        }
        catch (IOException e) {
            log.error("Error checking if body is empty", (Throwable)e);
            return this.resultForNoEvaluation(type);
        }
        try {
            return this.castType(exchange, flow, type);
        }
        catch (PathNotFoundException e) {
            if (type.isAssignableFrom(Boolean.class)) {
                return type.cast(Boolean.FALSE);
            }
            return null;
        }
        catch (InvalidPathException ipe) {
            log.error("{} is an invalid jsonpath: {}", (Object)this.expression, (Object)ipe.getMessage());
            throw new ExchangeExpressionException(this.expression, ipe);
        }
        catch (MismatchedInputException e) {
            String body = exchange.getMessage(flow).getBodyAsStringDecoded();
            if (body == null || body.isEmpty()) {
                log.info("Error evaluating Jsonpath {}. Body is empty!", (Object)this.expression);
            } else {
                log.info("Error evaluating Jsonpath {}. Body is: {}", (Object)this.expression, (Object)StringUtil.truncateAfter(body, 200));
            }
            throw new ExchangeExpressionException(this.expression, e);
        }
        catch (Exception e) {
            log.info("Error evaluating Jsonpath {}. Got message {}", (Object)this.expression, (Object)e);
            throw new ExchangeExpressionException(this.expression, e);
        }
    }

    @Nullable
    private <T> T castType(Exchange exchange, Interceptor.Flow flow, Class<T> type) throws IOException {
        Object o = this.execute(exchange, flow);
        if (type.getName().equals("java.lang.Object") || type.isInstance(o)) {
            return type.cast(o);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                return type.cast(b);
            }
            return type.cast(this.convertToBoolean(o));
        }
        if (String.class.isAssignableFrom(type)) {
            if (o instanceof List) {
                List l = (List)o;
                return type.cast(l.getFirst().toString());
            }
            if (o instanceof JSONAware) {
                JSONAware ja = (JSONAware)o;
                return type.cast(ja.toJSONString());
            }
            return type.cast(o.toString());
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return type.cast(String.valueOf(i));
        }
        return type.cast(o);
    }

    private <T> T resultForNoEvaluation(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return type.cast("");
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return type.cast(Boolean.FALSE);
        }
        return type.cast(new Object());
    }

    private boolean convertToBoolean(Object o) {
        return o != null;
    }

    private Object execute(Exchange exchange, Interceptor.Flow flow) throws IOException {
        return JsonPath.read((Object)this.om.readValue(exchange.getMessage(flow).getBodyAsStream(), Map.class), (String)this.expression, (Predicate[])new Predicate[0]);
    }
}

