/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.spel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.spel.AwareExchangePropertyAccessor;
import com.predic8.membrane.core.lang.spel.functions.BuiltInFunctionResolver;
import com.predic8.membrane.core.lang.spel.spelable.SpELHeader;
import com.predic8.membrane.core.lang.spel.spelable.SpELLablePropertyAware;
import com.predic8.membrane.core.lang.spel.spelable.SpELMap;
import com.predic8.membrane.core.lang.spel.spelable.SpELMessageWrapper;
import com.predic8.membrane.core.lang.spel.spelable.SpELPathParameters;
import com.predic8.membrane.core.lang.spel.spelable.SpELProperties;
import com.predic8.membrane.core.lang.spel.typeconverters.SpELHeaderToStringTypeConverter;
import com.predic8.membrane.core.lang.spel.typeconverters.SpELMapToStringTypeConverter;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class SpELExchangeEvaluationContext
extends StandardEvaluationContext {
    private static final Logger log = LoggerFactory.getLogger(SpELExchangeEvaluationContext.class);
    private static final ObjectMapper om = new ObjectMapper();
    private final Exchange exchange;
    private final Message message;
    private final SpELLablePropertyAware headers;
    private final SpELLablePropertyAware properties;
    private SpELLablePropertyAware params;
    private final SpELPathParameters pathParam;
    private String path;
    private String method;
    private int statusCode;
    private String scopes;
    private SpELMessageWrapper request;
    private SpELMessageWrapper response;
    private final Interceptor.Flow flow;

    public SpELExchangeEvaluationContext(Exchange exchange, Interceptor.Flow flow) {
        this.exchange = exchange;
        this.flow = flow;
        this.message = exchange.getMessage(flow);
        this.pathParam = new SpELPathParameters(exchange);
        this.properties = new SpELProperties(exchange.getProperties());
        this.headers = new SpELHeader(this.message.getHeader());
        this.extractFromRequest(exchange);
        this.extractFromResponse(exchange);
        this.setRootObject((Object)this);
        this.addPropertyAccessor(new AwareExchangePropertyAccessor());
        this.setMethodResolvers(List.of(new BuiltInFunctionResolver()));
        this.addTypeConverters();
    }

    private void addTypeConverters() {
        DefaultConversionService cs = new DefaultConversionService();
        cs.addConverter((Converter)new SpELHeaderToStringTypeConverter());
        cs.addConverter((Converter)new SpELMapToStringTypeConverter());
        this.setTypeConverter((TypeConverter)new StandardTypeConverter((ConversionService)cs));
    }

    private void extractFromResponse(Exchange exchange) {
        Response response = exchange.getResponse();
        if (response == null) {
            return;
        }
        this.response = new SpELMessageWrapper(response);
        this.statusCode = response.getStatusCode();
    }

    private void extractFromRequest(Exchange exchange) {
        Request request = exchange.getRequest();
        if (request == null) {
            return;
        }
        this.path = request.getUri();
        this.method = request.getMethod();
        try {
            this.params = new SpELMap<String, String>(URLParamUtil.getParams(new URIFactory(), exchange, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR));
        }
        catch (Exception e) {
            log.info("Error parsing query parameters");
        }
        this.request = new SpELMessageWrapper(exchange.getRequest());
    }

    public SpELLablePropertyAware getProperties() {
        return this.properties;
    }

    public SpELLablePropertyAware getProperty() {
        return this.properties;
    }

    public SpELLablePropertyAware getHeaders() {
        return this.headers;
    }

    public SpELLablePropertyAware getHeader() {
        return this.headers;
    }

    public SpELLablePropertyAware getParam() {
        return this.params;
    }

    public SpELLablePropertyAware getParams() {
        return this.params;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public SpELMessageWrapper getRequest() {
        return this.request;
    }

    public SpELMessageWrapper getResponse() {
        return this.response;
    }

    public String getScopes() {
        return this.scopes;
    }

    public Interceptor.Flow getFlow() {
        return this.flow;
    }

    public SpELLablePropertyAware getPathParam() {
        return this.pathParam;
    }

    public SpELMap<String, Object> getJson() throws IOException {
        return new SpELMap<String, Object>((Map)om.readValue(this.message.getBodyAsStreamDecoded(), Map.class));
    }
}

