/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.spel;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.lang.spel.SpELExchangeEvaluationContext;
import com.predic8.membrane.core.lang.spel.spelable.SpELLablePropertyAware;
import com.predic8.membrane.core.util.ConfigurationException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpELExchangeExpression
extends AbstractExchangeExpression {
    private static final Logger log = LoggerFactory.getLogger(SpELExchangeExpression.class);
    private final Expression spelExpression;

    public SpELExchangeExpression(String expression, TemplateParserContext parserContext) {
        super(expression);
        Throwable exception;
        Object posLine = "";
        try {
            this.spelExpression = new SpelExpressionParser(this.getSpelParserConfiguration()).parseExpression(expression, (ParserContext)parserContext);
            return;
        }
        catch (ParseException e) {
            int pos = e.getPosition();
            posLine = " ".repeat(pos) + "^";
            exception = e;
        }
        catch (Exception e) {
            exception = e;
        }
        throw new ConfigurationException("Error in expression:\n\n%s\n%s\n".formatted(expression, posLine), exception);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
        try {
            Object o = this.evaluate(exchange, flow);
            if (Boolean.class.isAssignableFrom(type)) {
                return type.cast(SpELExchangeExpression.toBoolean(o));
            }
            if (String.class.isAssignableFrom(type)) {
                return type.cast(SpELExchangeExpression.toString(o));
            }
            if (Object.class.isAssignableFrom(type)) {
                return type.cast(SpELExchangeExpression.toObject(o));
            }
            throw new RuntimeException("Cannot cast {} to {}".formatted(o, type));
        }
        catch (SpelEvaluationException see) {
            log.error("Error in expression '{}': {}", (Object)this.expression, (Object)see.getLocalizedMessage());
            ExchangeExpressionException eee = new ExchangeExpressionException(this.expression, see);
            Throwable throwable = see.getCause();
            if (throwable instanceof ConverterNotFoundException) {
                ConverterNotFoundException cnfe = (ConverterNotFoundException)throwable;
                eee.extension("sourceType", cnfe.getSourceType()).extension("targetType", cnfe.getTargetType());
            }
            eee.stacktrace(false);
            throw eee;
        }
    }

    @Nullable
    private Object evaluate(Exchange exchange, Interceptor.Flow flow) {
        return this.spelExpression.getValue((EvaluationContext)new SpELExchangeEvaluationContext(exchange, flow), Object.class);
    }

    private static Object toObject(Object o) {
        if (o == null) {
            return null;
        }
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, SpELLablePropertyAware.class}, (Object)object2, n)) {
            case 0: {
                String s = (String)object2;
                if (!s.isEmpty()) break;
                return null;
            }
            case 1: {
                SpELLablePropertyAware spa = (SpELLablePropertyAware)object2;
                return spa.getValue();
            }
        }
        return o;
    }

    private static String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof SpELLablePropertyAware) {
            SpELLablePropertyAware spa = (SpELLablePropertyAware)o;
            return spa.getValue().toString();
        }
        return o.toString();
    }

    private static boolean toBoolean(Object o) {
        if (o == null) {
            return Boolean.FALSE;
        }
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, SpELLablePropertyAware.class}, (Object)object2, n)) {
            case 0: {
                String s = (String)object2;
                if (s.isEmpty()) {
                    return Boolean.FALSE;
                }
                return Boolean.parseBoolean(s);
            }
            case 1: {
                SpELLablePropertyAware spa = (SpELLablePropertyAware)object2;
                return spa.getValue() != null;
            }
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b;
        }
        return Boolean.FALSE;
    }

    @NotNull
    private SpelParserConfiguration getSpelParserConfiguration() {
        return new SpelParserConfiguration(SpelCompilerMode.MIXED, this.getClass().getClassLoader());
    }

    public static class DollarBracketTemplateParserContext
    extends TemplateParserContext {
        public DollarBracketTemplateParserContext() {
            super("${", "}");
        }
    }
}

