/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.spel.functions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.predic8.membrane.core.interceptor.AbstractInterceptorWithSession;
import com.predic8.membrane.core.lang.spel.SpELExchangeEvaluationContext;
import com.predic8.membrane.core.security.SecurityScheme;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInFunctions {
    private static final Logger log = LoggerFactory.getLogger(BuiltInFunctions.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Object jsonPath(String jsonPath, SpELExchangeEvaluationContext ctx) {
        try {
            return JsonPath.read((Object)objectMapper.readValue(ctx.getMessage().getBodyAsStringDecoded(), Map.class), (String)jsonPath, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean weight(double weightInPercent, SpELExchangeEvaluationContext ignored) {
        return Math.max(0.0, Math.min(1.0, weightInPercent / 100.0)) > ThreadLocalRandom.current().nextDouble();
    }

    public static boolean isLoggedIn(String beanName, SpELExchangeEvaluationContext ctx) {
        try {
            return ((AbstractInterceptorWithSession)Objects.requireNonNull(ctx.getExchange().getHandler().getTransport().getRouter().getBeanFactory()).getBean(beanName)).getSessionManager().getSession(ctx.getExchange()).isVerified();
        }
        catch (Exception e) {
            log.info("Failed to resolve bean with name '{}'", (Object)beanName);
            return false;
        }
    }

    public static boolean isBearerAuthorization(SpELExchangeEvaluationContext ctx) {
        return ctx.getExchange().getRequest().getHeader().contains("Authorization") && ctx.getExchange().getRequest().getHeader().getFirstValue("Authorization").startsWith("Bearer");
    }

    public static List<String> scopes(SpELExchangeEvaluationContext ctx) {
        return BuiltInFunctions.getSchemeScopes(BuiltInFunctions.all(), ctx);
    }

    public static List<String> scopes(String securityScheme, SpELExchangeEvaluationContext ctx) {
        return BuiltInFunctions.getSchemeScopes(BuiltInFunctions.name(securityScheme), ctx);
    }

    public static boolean hasScope(String scope, SpELExchangeEvaluationContext ctx) {
        return BuiltInFunctions.scopesContainsByPredicate(ctx, it -> it.contains(scope));
    }

    public static boolean hasScope(SpELExchangeEvaluationContext ctx) {
        return BuiltInFunctions.scopesContainsByPredicate(ctx, it -> !it.isEmpty());
    }

    public static boolean hasScope(List<String> scopes, SpELExchangeEvaluationContext ctx) {
        return BuiltInFunctions.scopesContainsByPredicate(ctx, it -> it.containsAll(scopes));
    }

    private static Boolean scopesContainsByPredicate(SpELExchangeEvaluationContext ctx, Predicate<List<String>> predicate) {
        return predicate.test(BuiltInFunctions.getSchemeScopes(BuiltInFunctions.all(), ctx));
    }

    private static List<String> getSchemeScopes(Predicate<SecurityScheme> predicate, SpELExchangeEvaluationContext ctx) {
        return Optional.ofNullable((List)ctx.getExchange().getProperty("membrane.security.schemes")).map(list -> list.stream().filter(predicate).map(SecurityScheme::getScopes).flatMap(Collection::stream).toList()).orElse(Collections.emptyList());
    }

    private static Predicate<SecurityScheme> all() {
        return ignored -> true;
    }

    private static Predicate<SecurityScheme> name(String name) {
        return scheme -> scheme.getName().equalsIgnoreCase(name);
    }

    public static boolean isXML(SpELExchangeEvaluationContext ctx) {
        return ctx.getMessage().isXML();
    }

    public static boolean isJSON(SpELExchangeEvaluationContext ctx) {
        return ctx.getMessage().isJSON();
    }

    public static String base64Encode(String s, SpELExchangeEvaluationContext ctx) {
        return Base64.getEncoder().encodeToString(s.getBytes());
    }
}

