/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.spel.functions;

import com.predic8.membrane.core.lang.spel.SpELExchangeEvaluationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;

public class ReflectiveMethodHandler {
    private final List<Method> storedMethods;

    public ReflectiveMethodHandler(Class<?> clazz) {
        this.storedMethods = Arrays.stream(clazz.getMethods()).filter(mth -> Modifier.isPublic(mth.getModifiers())).toList();
    }

    static TypeDescriptor getTypeDescriptor(Class<?> type) {
        return new TypeDescriptor(ResolvableType.forClass(type), type, null);
    }

    public TypedValue invokeFunction(EvaluationContext ctx, String func, List<TypeDescriptor> types, Object ... args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return new TypedValue(this.getFunction(func, ReflectiveMethodHandler.getParameterTypeDescriptors(types)).invoke(null, ReflectiveMethodHandler.getParameters(ctx, args)));
    }

    private static ArrayList<TypeDescriptor> getParameterTypeDescriptors(List<TypeDescriptor> types) {
        return new ArrayList<TypeDescriptor>(types){
            {
                this.add(ReflectiveMethodHandler.getTypeDescriptor(SpELExchangeEvaluationContext.class));
            }
        };
    }

    private static Object[] getParameters(final EvaluationContext ctx, Object[] args) {
        return new ArrayList<Object>(List.of(args)){
            {
                super(c);
                this.add(ctx);
            }
        }.toArray();
    }

    Method getFunction(String func, List<TypeDescriptor> t) throws NoSuchMethodException {
        return this.storedMethods.stream().filter(m -> m.getName().equals(func) && this.validateTypeSignature(ReflectiveMethodHandler.getTypeDescriptors(m), t)).findFirst().orElseThrow(NoSuchMethodException::new);
    }

    static List<TypeDescriptor> getTypeDescriptors(Method m) {
        return Arrays.stream(m.getParameterTypes()).map(ReflectiveMethodHandler::getTypeDescriptor).toList();
    }

    boolean validateTypeSignature(List<TypeDescriptor> template, List<TypeDescriptor> provided) {
        return template.size() == provided.size() && IntStream.range(0, template.size()).allMatch(i -> ((TypeDescriptor)provided.get(i)).isAssignableTo((TypeDescriptor)template.get(i)));
    }
}

