/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.xpath;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.util.XMLUtil;
import com.predic8.membrane.core.util.xml.NodeListWrapper;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class XPathExchangeExpression
extends AbstractExchangeExpression {
    private static final Logger log = LoggerFactory.getLogger((String)XPathExchangeExpression.class.getName());
    private static final XPathFactory factory = XPathFactory.newInstance();

    public XPathExchangeExpression(String xpath) {
        super(xpath);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Interceptor.Flow flow, Class<T> type) {
        Message msg = exchange.getMessage(flow);
        try {
            if (Boolean.class.isAssignableFrom(type)) {
                return type.cast(this.evalutateAndCast(msg, XPathConstants.BOOLEAN));
            }
            if (String.class.isAssignableFrom(type)) {
                return type.cast(this.evalutateAndCast(msg, XPathConstants.STRING));
            }
            if (Object.class.isAssignableFrom(type)) {
                return type.cast(this.evaluateAndCastToObject(msg));
            }
            throw new RuntimeException("Should not Happen!");
        }
        catch (XPathExpressionException xee) {
            throw new ExchangeExpressionException(this.expression, xee).body(msg.getBodyAsStringDecoded()).stacktrace(false);
        }
    }

    private Object evaluateAndCastToObject(Message msg) throws XPathExpressionException {
        Object t = this.evalutateAndCast(msg, XPathConstants.NODESET);
        if (t instanceof NodeList) {
            NodeList nl = (NodeList)t;
            return new NodeListWrapper(nl);
        }
        return t;
    }

    private Object evalutateAndCast(Message msg, QName xmlType) throws XPathExpressionException {
        if (log.isDebugEnabled()) {
            log.debug("Evaluating: {}", (Object)this.expression);
            log.debug("Body: {}", (Object)msg.getBodyAsStringDecoded());
        }
        return factory.newXPath().evaluate(this.expression, XMLUtil.getInputSource(msg), xmlType);
    }
}

