/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.multipart;

import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.multipart.Part;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.MessageUtil;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.fileupload.MultipartStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class XOPReconstitutor {
    private static final Logger log = LoggerFactory.getLogger((String)XOPReconstitutor.class.getName());
    private static final String XOP_NAMESPACE_URI = "http://www.w3.org/2004/08/xop/include";
    private final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public XOPReconstitutor() {
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    public InputStream reconstituteIfNecessary(Message message) throws IOException {
        try {
            Message reconstitutedMessage = this.getReconstitutedMessage(message);
            if (reconstitutedMessage != null) {
                return reconstitutedMessage.getBodyAsStream();
            }
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        return MessageUtil.getContentAsStream(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLEventReader createEventReaderFromStream(InputStream is) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = this.xmlInputFactory;
        synchronized (xMLInputFactory) {
            return this.xmlInputFactory.createXMLEventReader(is);
        }
    }

    public Message getReconstitutedMessage(Message message) throws ParseException, IOException, EndOfStreamException, XMLStreamException, FactoryConfigurationError {
        if (message == null) {
            return null;
        }
        ContentType contentType = message.getHeader().getContentTypeObject();
        if (contentType == null || contentType.getPrimaryType() == null) {
            return null;
        }
        if (!contentType.getPrimaryType().equals("multipart") || !contentType.getSubType().equals("related")) {
            return null;
        }
        String type = contentType.getParameter("type");
        if (!"application/xop+xml".equals(type)) {
            return null;
        }
        String start = contentType.getParameter("start");
        if (start == null) {
            return null;
        }
        String boundary = contentType.getParameter("boundary");
        if (boundary == null) {
            return null;
        }
        HashMap<String, Part> parts = this.split(message, boundary);
        Part startPart = parts.get(start);
        if (startPart == null) {
            return null;
        }
        ContentType innerContentType = new ContentType(startPart.getHeader().getContentType());
        if (!innerContentType.getPrimaryType().equals("application") || !innerContentType.getSubType().equals("xop+xml")) {
            return null;
        }
        byte[] body = this.fillInXOPParts(startPart.getInputStream(), parts);
        Message m = new Message(this){

            @Override
            protected void parseStartLine(InputStream in) {
                throw new RuntimeException("not implemented.");
            }

            @Override
            public String getStartLine() {
                throw new RuntimeException("not implemented.");
            }

            @Override
            public <T extends Message> T createSnapshot(Runnable bodyUpdatedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) {
                throw new RuntimeException("not implemented.");
            }

            @Override
            public boolean shouldNotContainBody() {
                return false;
            }
        };
        m.setBodyContent(body);
        String reconstitutedContentType = innerContentType.getParameter("type");
        if (reconstitutedContentType != null) {
            m.getHeader().add("Content-Type", reconstitutedContentType);
        }
        return m;
    }

    private HashMap<String, Part> split(Message message, String boundary) throws IOException, EndOfStreamException {
        HashMap<String, Part> parts = new HashMap<String, Part>();
        MultipartStream multipartStream = new MultipartStream(MessageUtil.getContentAsStream(message), boundary.getBytes(StandardCharsets.UTF_8));
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            Header header = new Header(multipartStream.readHeaders());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            multipartStream.readBodyData((OutputStream)baos);
            String cte = header.getFirstValue("Content-Transfer-Encoding");
            if (!(cte == null || cte.equals("binary") || cte.equals("8bit") || cte.equals("7bit"))) {
                throw new RuntimeException("Content-Transfer-Encoding '" + cte + "' not implemented.");
            }
            Part part = new Part(header, baos.toByteArray());
            String id = part.getContentID();
            if (id != null) {
                parts.put(id, part);
            }
            nextPart = multipartStream.readBoundary();
        }
        return parts;
    }

    private byte[] fillInXOPParts(InputStream inputStream, HashMap<String, Part> parts) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(baos);
        try {
            XMLEventReader parser = this.createEventReaderFromStream(inputStream);
            boolean xopIncludeOpen = false;
            while (parser.hasNext()) {
                EndElement start;
                XMLEvent event = parser.nextEvent();
                if (event instanceof StartElement) {
                    StartElement start2 = (StartElement)event;
                    if (XOP_NAMESPACE_URI.equals(start2.getName().getNamespaceURI()) && start2.getName().getLocalPart().equals("Include")) {
                        Part p;
                        String href = start2.getAttributeByName(new QName("href")).getValue();
                        if (href.startsWith("cid:")) {
                            href = href.substring(4);
                        }
                        if ((p = parts.get("<" + href + ">")) == null) {
                            throw new RuntimeException("Did not find multipart with id " + href);
                        }
                        writer.add(p.asXMLEvent());
                        xopIncludeOpen = true;
                        continue;
                    }
                } else if (event instanceof EndElement && XOP_NAMESPACE_URI.equals((start = (EndElement)event).getName().getNamespaceURI()) && start.getName().getLocalPart().equals("Include") && xopIncludeOpen) {
                    xopIncludeOpen = false;
                    continue;
                }
                writer.add(event);
            }
            writer.flush();
        }
        catch (XMLStreamException e) {
            log.warn("Received not-wellformed XML.");
            return null;
        }
        return baos.toByteArray();
    }
}

