/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi;

import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.model.Response;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.MethodNotAllowException;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.validators.OperationValidator;
import com.predic8.membrane.core.openapi.validators.PathParametersValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URIFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIValidator {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIValidator.class.getName());
    private final OpenAPIRecord rec;
    private final URIFactory uriFactory;
    private String basePath = "";

    public OpenAPIValidator(URIFactory uriFactory, OpenAPIRecord rec) {
        this.rec = rec;
        this.uriFactory = uriFactory;
        this.init();
    }

    private void init() {
        if (this.rec.getApi().getServers() != null) {
            log.debug("Found server {}", (Object)this.getUrl());
            try {
                this.basePath = UriUtil.getPathFromURL(this.uriFactory, this.getUrl());
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Error initializing OpenAPI validator. Path was: %s ".formatted(this.getUrl()), e);
            }
        }
    }

    private String getUrl() {
        if (this.rec.getSpec().hasRewrite() && this.rec.getSpec().getRewrite().getBasePath() != null) {
            return this.rec.getSpec().getRewrite().getBasePath();
        }
        return ((Server)this.rec.getApi().getServers().getFirst()).getUrl();
    }

    public ValidationErrors validate(Request<? extends Body> request) {
        return this.validateMessage(request, null);
    }

    public ValidationErrors validateResponse(Request<? extends Body> request, Response<? extends Body> response) {
        return this.validateMessage(request, response);
    }

    private ValidationErrors validateMessage(Request<? extends Body> req, Response<? extends Body> res) {
        for (Map.Entry path : this.rec.getApi().getPaths().entrySet()) {
            try {
                return this.validateMethodsAndParametersIfPathMatches(req, res, (String)path.getKey(), (PathItem)path.getValue());
            }
            catch (PathDoesNotMatchException pathDoesNotMatchException) {
            }
        }
        return ValidationErrors.create(ValidationContext.fromRequest(req).entity(req.getPath()).entityType(ValidationContext.ValidatedEntityType.PATH).statusCode(404), String.format("Path %s is invalid.", req.getPath()));
    }

    private ValidationErrors validateMethodsAndParametersIfPathMatches(Request<? extends Body> req, Response<? extends Body> response, String uriTemplate, PathItem pathItem) throws PathDoesNotMatchException {
        req.parsePathParameters(UriUtil.normalizeUri(this.basePath + uriTemplate));
        ValidationContext ctx = ValidationContext.fromRequest(req);
        ValidationErrors errors = this.validateMethods(ctx.uriTemplate(uriTemplate), req, response, pathItem);
        if (response == null) {
            errors.add(new PathParametersValidator(this.rec.getApi()).validatePathParameters(ctx.uriTemplate(uriTemplate), req, pathItem.getParameters()));
        }
        return errors;
    }

    private ValidationErrors validateMethods(ValidationContext ctx, Request<? extends Body> req, Response<? extends Body> response, PathItem pathItem) {
        ValidationErrors errors = new ValidationErrors();
        try {
            return errors.add(new OperationValidator(this.rec.getApi()).validateOperation(ctx, req, response, pathItem));
        }
        catch (MethodNotAllowException e) {
            return errors.add(ctx.statusCode(405).entity(req.getMethod()).entityType(ValidationContext.ValidatedEntityType.METHOD), String.format("Method %s is not allowed", req.getMethod()));
        }
    }

    public OpenAPI getApi() {
        return this.rec.getApi();
    }
}

