/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.InputStreamBody;
import com.predic8.membrane.core.openapi.model.JsonBody;
import com.predic8.membrane.core.openapi.model.NoBody;
import com.predic8.membrane.core.openapi.model.StringBody;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class Message<T extends Body, S extends Message<T, S>> {
    protected Body body = new NoBody();
    protected ContentType mediaType;
    private final Headers headers = new Headers();

    protected Message() {
    }

    public Headers getHeaders() {
        return this.headers;
    }

    protected Message(String mediaType) throws ParseException {
        this.mediaType = new ContentType(mediaType);
    }

    public Body getBody() {
        return this.body;
    }

    public S body(Body body) {
        this.body = body;
        if (body instanceof JsonBody) {
            this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        }
        return (S)this;
    }

    public S body(InputStream inputStream) {
        this.body = new InputStreamBody(inputStream);
        return (S)this;
    }

    public S body(String s) {
        this.body = new StringBody(s);
        return (S)this;
    }

    public S body(JsonNode n) {
        this.body = new JsonBody(n);
        this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        return (S)this;
    }

    public S mediaType(String mediaType) throws ParseException {
        this.mediaType = new ContentType(mediaType);
        return (S)this;
    }

    public S json() {
        this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        return (S)this;
    }

    public boolean isOfMediaType(String mediaType) {
        if (mediaType.startsWith("*/*")) {
            return true;
        }
        return this.mediaType.match(mediaType);
    }

    public boolean hasBody() {
        if (this.body == null) {
            return false;
        }
        return !(this.body instanceof NoBody);
    }

    public ContentType getMediaType() {
        return this.mediaType;
    }

    public static class Headers {
        private Map<HeaderKey, String> fields = new HashMap<HeaderKey, String>();

        public void put(String key, String value) {
            this.fields.put(new HeaderKey(key), value);
        }

        public String get(String key) {
            return this.fields.get(new HeaderKey(key));
        }

        public int size() {
            return this.fields.size();
        }

        static class HeaderKey {
            private final String key;

            public HeaderKey(String key) {
                this.key = key;
            }

            public int hashCode() {
                return this.key.toLowerCase().hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                return this.key.equalsIgnoreCase(((HeaderKey)obj).key);
            }
        }
    }
}

