/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.model;

import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriTemplateMatcher;
import com.predic8.membrane.core.security.SecurityScheme;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Request<T extends Body>
extends Message<T, Request<T>> {
    private final String method;
    private String path;
    private Map<String, String> pathParameters;
    private List<SecurityScheme> securitySchemes = Collections.emptyList();
    private Set<String> scopes;

    public Request(String method) {
        this.method = method;
    }

    public Request(String method, String path) {
        this.method = method;
        this.path = path;
    }

    public static <T extends Body> Request<T> get() {
        return new Request<T>("GET");
    }

    public static <T extends Body> Request<T> post() {
        return new Request<T>("POST");
    }

    public static <T extends Body> Request<T> put() {
        return new Request<T>("PUT");
    }

    public static <T extends Body> Request<T> delete() {
        return new Request<T>("DELETE");
    }

    public static <T extends Body> Request<T> patch() {
        return new Request<T>("PATCH");
    }

    public static <T extends Body> Request<T> trace() {
        return new Request<T>("TRACE");
    }

    public Request<T> path(String path) {
        this.path = path;
        return this;
    }

    public Request<T> securitySchemes(List<SecurityScheme> schemes) {
        this.securitySchemes = schemes;
        return this;
    }

    public Request<T> scopes(String ... scope) {
        this.scopes = Arrays.stream(scope).collect(Collectors.toSet());
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public List<SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(List<SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public boolean hasScheme(SecurityScheme scheme) {
        return this.securitySchemes.stream().anyMatch(s -> s.equals(scheme));
    }

    public void parsePathParameters(String uriTemplate) throws PathDoesNotMatchException {
        this.pathParameters = UriTemplateMatcher.matchTemplate(uriTemplate, this.path);
    }

    public String toString() {
        return "Request{method='" + this.method + "', path='" + this.path + "', pathParameters=" + String.valueOf(this.pathParameters) + ", securityScheme=" + String.valueOf(this.securitySchemes) + ", scopes=" + String.valueOf(this.scopes) + "}";
    }
}

