/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.interceptor.lang.Polyglot;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxyKey;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIInterceptor;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIPublisherInterceptor;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecordFactory;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPISpec;
import com.predic8.membrane.core.openapi.serviceproxy.ValidationStatisticsCollector;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.proxies.ServiceProxy;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URIFactory;
import io.swagger.v3.oas.models.servers.Server;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="api")
public class APIProxy
extends ServiceProxy
implements Polyglot {
    private static final Logger log = LoggerFactory.getLogger((String)APIProxy.class.getName());
    public static final String X_MEMBRANE_VALIDATION = "x-membrane-validation";
    public static final String X_MEMBRANE_ID = "x-membrane-id";
    public static final String REQUESTS = "requests";
    public static final String RESPONSES = "responses";
    public static final String SECURITY = "security";
    public static final String VALIDATION_DETAILS = "details";
    private ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;
    private ExchangeExpression exchangeExpression;
    private String test;
    private String id;
    private ApiDescription description;
    protected Map<String, OpenAPIRecord> apiRecords = new LinkedHashMap<String, OpenAPIRecord>();
    protected Map<String, OpenAPIRecord> basePaths;
    protected final ValidationStatisticsCollector statisticCollector = new ValidationStatisticsCollector();
    protected List<OpenAPISpec> specs = new ArrayList<OpenAPISpec>();

    public List<OpenAPISpec> getSpecs() {
        return this.specs;
    }

    @MCChildElement(order=25)
    public void setSpecs(List<OpenAPISpec> specs) {
        this.specs = specs;
    }

    @Override
    public void init() {
        super.init();
        if (this.test != null && !this.test.isEmpty()) {
            this.exchangeExpression = ExchangeExpression.newInstance(this.router, this.language, this.test);
        }
        this.key = new APIProxyKey(this.key, this.exchangeExpression, !this.specs.isEmpty());
        this.initOpenAPI();
    }

    private void initOpenAPI() {
        if (this.specs.isEmpty()) {
            return;
        }
        this.apiRecords = new OpenAPIRecordFactory(this.router).create(this.specs);
        this.checkForDuplicatePaths();
        this.basePaths = this.getOpenAPIMap();
        this.configureBasePaths();
        if (this.getFirstInterceptorOfType(OpenAPIInterceptor.class).isEmpty()) {
            this.interceptors.addFirst(new OpenAPIInterceptor(this));
        }
        if (this.getFirstInterceptorOfType(OpenAPIPublisherInterceptor.class).isEmpty()) {
            this.interceptors.addFirst(new OpenAPIPublisherInterceptor(this.apiRecords));
        }
    }

    void checkForDuplicatePaths() {
        HashMap paths = new HashMap();
        this.apiRecords.values().forEach(rec -> {
            for (Server server : rec.api.getServers()) {
                List l;
                String path = APIProxy.getUriPath(server);
                if (paths.containsKey(path) && !(l = (List)paths.get(path)).contains(rec)) {
                    throw new ConfigurationException("================================================================================================\n\nConfiguration Error: Several OpenAPI Documents share the same path!\n\nAn API routes and validates requests according to the path of the OpenAPI's servers.url fields.\nWithin one API the same path should be used only by one OpenAPI. Change the paths or place\nopenapi-elements into separate APIs.\n\nShared path: %s\n%n".formatted(path));
                }
                paths.computeIfAbsent(path, s -> {
                    ArrayList<OpenAPIRecord> apis = new ArrayList<OpenAPIRecord>();
                    apis.add((OpenAPIRecord)rec);
                    return apis;
                });
            }
        });
    }

    private static String getUriPath(Server server) {
        try {
            return new URIFactory(true).create(server.getUrl()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureBasePaths() {
        ((APIProxyKey)this.key).addBasePaths(new ArrayList<String>(this.basePaths.keySet()));
    }

    private Map<String, OpenAPIRecord> getOpenAPIMap() {
        HashMap<String, OpenAPIRecord> paths = new HashMap<String, OpenAPIRecord>();
        this.apiRecords.forEach((id, rec) -> rec.api.getServers().forEach(server -> {
            String url = server.getUrl();
            if (rec.spec.getRewrite() != null && rec.spec.getRewrite().basePath != null) {
                url = rec.spec.getRewrite().basePath;
            }
            try {
                paths.put(UriUtil.getPathFromURL(this.router.getUriFactory(), url), (OpenAPIRecord)rec);
            }
            catch (URISyntaxException e) {
                log.error("Cannot parse URL {}", (Object)url);
                throw new RuntimeException("Cannot parse URL %s".formatted(url));
            }
        }));
        return paths;
    }

    public ValidationStatisticsCollector getValidationStatisticCollector() {
        return this.statisticCollector;
    }

    public Map<String, OpenAPIRecord> getApiRecords() {
        return this.apiRecords;
    }

    public Map<String, OpenAPIRecord> getBasePaths() {
        return this.basePaths;
    }

    public String getTest() {
        return this.test;
    }

    @MCAttribute
    public void setTest(String test) {
        this.test = test;
    }

    public String getId() {
        return this.id;
    }

    public ApiDescription getDescription() {
        return this.description;
    }

    @MCAttribute
    public void setId(String id) {
        this.id = id;
    }

    @MCChildElement
    public void setDescription(ApiDescription description) {
        this.description = description;
    }

    @Override
    @MCAttribute
    public void setLanguage(String language) {
        try {
            this.language = ExchangeExpression.Language.valueOf(language);
        }
        catch (Exception e) {
            throw new ConfigurationException("Wrong Language\n\nLanguage %s is not supported as an expression language for %s. Use one of {}.\n".formatted(new Object[]{language, this.getName(), ExchangeExpression.Language.values()}));
        }
    }

    @MCElement(name="description", topLevel=false, mixed=true)
    public static class ApiDescription {
        private String content;

        @MCTextContent
        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

