/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriTemplateMatcher;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.proxies.ServiceProxyKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIProxyKey
extends ServiceProxyKey {
    private static final Logger log = LoggerFactory.getLogger((String)APIProxyKey.class.getName());
    private final ArrayList<String> basePaths = new ArrayList();
    private ExchangeExpression exchangeExpression;

    public APIProxyKey(RuleKey key, ExchangeExpression exchangeExpression, boolean openAPI) {
        super(key);
        this.init(exchangeExpression, openAPI);
        this.setUsePathPattern(true);
    }

    public APIProxyKey(int port) {
        this(null, "*", port, null, "*", null, true);
    }

    public APIProxyKey(String ip, String host, int port, String path, String method, ExchangeExpression exchangeExpression, boolean openAPI) {
        super(host, method, path, port, ip);
        this.init(exchangeExpression, openAPI);
        this.setUsePathPattern(true);
    }

    protected void init(ExchangeExpression exchangeExpression, boolean openAPI) {
        this.exchangeExpression = exchangeExpression;
        if (!openAPI) {
            return;
        }
        this.basePaths.add("/api-docs");
        this.basePaths.add("/api-docs/ui");
        this.basePaths.add("/api-doc");
        this.basePaths.add("/api-doc/ui");
    }

    @Override
    public boolean complexMatch(Exchange exc) {
        try {
            if (!this.testCondition(exc)) {
                return false;
            }
        }
        catch (Exception e) {
            log.warn("Error evaluating test expression '{}' of API '{}'. Ignoring test. Please check configuration. Error was: {}", new Object[]{this.exchangeExpression.getExpression(), this, e.getMessage()});
            return false;
        }
        if (this.basePaths.isEmpty()) {
            return true;
        }
        String uri = exc.getRequest().getUri();
        for (String basePath : this.basePaths) {
            if (!uri.startsWith(basePath)) continue;
            log.debug("Rule matches {}", (Object)uri);
            return true;
        }
        return false;
    }

    private boolean testCondition(Exchange exc) {
        if (this.exchangeExpression == null) {
            return true;
        }
        return this.exchangeExpression.evaluate(exc, Interceptor.Flow.REQUEST, Boolean.class);
    }

    void addBasePaths(ArrayList<String> paths) {
        this.basePaths.addAll(paths);
    }

    public String getKeyId() {
        return this.getMethod() + "-" + Optional.ofNullable(this.getIp()).orElse("0.0.0.0") + "-" + this.getHost() + this.getPort() + this.getPath() + (String)(this.exchangeExpression == null ? "" : "-" + this.exchangeExpression.getExpression());
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.exchangeExpression != null ? " " + this.exchangeExpression.getExpression() : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof APIProxyKey) {
            APIProxyKey other = (APIProxyKey)obj;
            if (!this.basePaths.equals(other.basePaths)) {
                return false;
            }
            return Objects.equals(this.exchangeExpression, other.exchangeExpression);
        }
        return false;
    }

    @Override
    public boolean matchesPath(String path) {
        try {
            UriTemplateMatcher.matchTemplate(this.getPath(), path);
            return true;
        }
        catch (PathDoesNotMatchException e) {
            log.debug("Path {} doesn't match {}", (Object)path, (Object)this.getPath());
            return path.startsWith(this.getPath());
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.exchangeExpression.hashCode()) + this.basePaths.hashCode();
    }
}

