/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIInterceptor;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIPublisher;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.serviceproxy.Rewrite;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.RuleKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="apiDocs")
public class ApiDocsInterceptor
extends AbstractInterceptor {
    private static final Pattern PATTERN_UI = Pattern.compile("/api-docs?/ui/(.*)");
    Map<String, OpenAPIRecord> ruleApiSpecs;
    private static final Logger log = LoggerFactory.getLogger((String)ApiDocsInterceptor.class.getName());
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome handleRequest(Exchange exc) {
        OpenAPIPublisher publisher;
        ApiDocsInterceptor apiDocsInterceptor = this;
        synchronized (apiDocsInterceptor) {
            if (!this.initialized) {
                this.ruleApiSpecs = this.initializeRuleApiSpecs();
                this.initialized = true;
            }
        }
        try {
            publisher = new OpenAPIPublisher(this.ruleApiSpecs);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("publisher-creation").detail("Error creating OpenAPI publisher!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (exc.getRequest().getUri().matches(String.valueOf(PATTERN_UI))) {
            return publisher.handleSwaggerUi(exc);
        }
        try {
            return publisher.handleOverviewOpenAPIDoc(exc, this.router, log);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("publisher-handling").detail("Error generating OpenAPI overview!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    public Map<String, OpenAPIRecord> initializeRuleApiSpecs() {
        return this.router.getRuleManager().getRules().stream().filter(this::hasOpenAPIInterceptor).peek(this::setSpecRewrites).flatMap(this::getRecordEntryStreamOrEmpty).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key1, ignored) -> key1, LinkedHashMap::new));
    }

    protected void setSpecRewrites(Proxy proxy) {
        final RuleKey key = proxy.getKey();
        ApiDocsInterceptor.getOpenAPIInterceptor(proxy).get().getApiProxy().getSpecs().forEach(spec -> {
            if (spec.getRewrite() != null) {
                ApiDocsInterceptor.setIfNull(spec.getRewrite(), Rewrite::getPort, Rewrite::setPort, key.getPort());
                ApiDocsInterceptor.setIfNull(spec.getRewrite(), Rewrite::getHost, Rewrite::setHost, key.getHost());
                ApiDocsInterceptor.setIfNull(spec.getRewrite(), Rewrite::getBasePath, Rewrite::setBasePath, key.getPath());
            } else {
                spec.setRewrite(new Rewrite(this){
                    {
                        this.setHost(key.getHost());
                        this.setPort(key.getPort());
                        this.setBasePath(key.getPath());
                    }
                });
            }
        });
    }

    private Stream<Map.Entry<String, OpenAPIRecord>> getRecordEntryStreamOrEmpty(Proxy proxy) {
        return ApiDocsInterceptor.getOpenAPIInterceptor(proxy).map(ApiDocsInterceptor::getRecordEntryStream).orElse(Stream.empty());
    }

    private static Stream<Map.Entry<String, OpenAPIRecord>> getRecordEntryStream(OpenAPIInterceptor oai) {
        return oai.getApiProxy().apiRecords.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), (OpenAPIRecord)entry.getValue()));
    }

    private boolean hasOpenAPIInterceptor(Proxy proxy) {
        return proxy.getInterceptors().stream().anyMatch(OpenAPIInterceptor.class::isInstance);
    }

    static Optional<OpenAPIInterceptor> getOpenAPIInterceptor(Proxy proxy) {
        return proxy.getInterceptors().stream().filter(OpenAPIInterceptor.class::isInstance).map(ic -> (OpenAPIInterceptor)ic).findFirst();
    }

    @Override
    public String getDisplayName() {
        return "api docs";
    }

    @Override
    public String getShortDescription() {
        return "Displays all deployed APIs";
    }

    @Override
    public String getLongDescription() {
        this.ruleApiSpecs = this.initializeRuleApiSpecs();
        this.initialized = true;
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<thead><th>API</th><th>OpenAPI Version</th></thead>");
        for (String ruleKey : this.ruleApiSpecs.keySet()) {
            OpenAPIRecord apiSpec = this.ruleApiSpecs.get(ruleKey);
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(ruleKey);
            sb.append("</td>");
            sb.append("<td>");
            sb.append(apiSpec.version);
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static <T, U> void setIfNull(T rewrite, Function<T, U> getter, BiConsumer<T, U> setter, U defaultValue) {
        if (getter.apply(rewrite) != null) {
            return;
        }
        if (defaultValue == null) {
            return;
        }
        if (!defaultValue.equals("*")) {
            setter.accept(rewrite, defaultValue);
        }
    }
}

