/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.OpenAPIParsingException;
import com.predic8.membrane.core.openapi.OpenAPIValidator;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.RuleKey;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="openapiValidator")
public class OpenAPIInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIInterceptor.class.getName());
    public static final String OPENAPI_RECORD = "OPENAPI_RECORD";
    protected APIProxy apiProxy;

    public OpenAPIInterceptor() {
    }

    public OpenAPIInterceptor(APIProxy apiProxy) {
        this.apiProxy = apiProxy;
    }

    @Override
    public void init() {
        Proxy parent;
        super.init();
        if (this.apiProxy == null && (parent = this.router.getParentProxy(this)) instanceof APIProxy) {
            APIProxy ap;
            this.apiProxy = ap = (APIProxy)parent;
        }
    }

    public APIProxy getApiProxy() {
        return this.apiProxy;
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        String basePath = this.getMatchingBasePath(exc);
        if (basePath == null) {
            ProblemDetails.user(false, this.getDisplayName()).title("No matching API found!").statusCode(404).addSubSee("not-found").detail("There is no API on the path %s deployed. Please check the path.".formatted(exc.getOriginalRequestUri())).topLevel("path", exc.getOriginalRequestUri()).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        OpenAPIRecord rec = this.apiProxy.getBasePaths().get(basePath);
        if (!this.hasProxyATargetElement()) {
            this.setDestinationsFromOpenAPI(rec, exc);
        }
        try {
            ValidationErrors errors = this.validateRequest(rec, exc);
            if (!errors.isEmpty()) {
                this.apiProxy.statisticCollector.collect(errors);
                this.createErrorResponse(exc, errors, ValidationErrors.Direction.REQUEST, this.validationDetails(rec.api));
                return Outcome.RETURN;
            }
        }
        catch (OpenAPIParsingException e) {
            String detail = "Could not parse OpenAPI with title %s. Check syntax and references.".formatted(rec.api.getInfo().getTitle());
            log.warn(detail);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("openapi-parsing").flow(Interceptor.Flow.REQUEST).detail(detail).exception(e).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        catch (Throwable t) {
            String LOG_MESSAGE = "Message could not be validated against OpenAPI cause of an error during validation. Please check the OpenAPI with title %s.";
            log.error("Message could not be validated against OpenAPI cause of an error during validation. Please check the OpenAPI with title %s.".formatted(rec.api.getInfo().getTitle()), t);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).addSubSee("generic").flow(Interceptor.Flow.REQUEST).detail("Message could not be validated against OpenAPI cause of an error during validation. Please check the OpenAPI with title %s.".formatted(rec.api.getInfo().getTitle())).exception(t).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        exc.setProperty(OPENAPI_RECORD, rec);
        return Outcome.CONTINUE;
    }

    private boolean hasProxyATargetElement() {
        return this.apiProxy.getTarget() != null && (this.apiProxy.getTarget().getHost() != null || this.apiProxy.getTarget().getUrl() != null);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        OpenAPIRecord rec = (OpenAPIRecord)exc.getProperty(OPENAPI_RECORD);
        try {
            ValidationErrors errors = this.validateResponse(rec, exc);
            if (errors != null && errors.hasErrors()) {
                exc.getResponse().setStatusCode(500);
                this.apiProxy.statisticCollector.collect(errors);
                this.createErrorResponse(exc, errors, ValidationErrors.Direction.RESPONSE, this.validationDetails(rec.api));
                return Outcome.RETURN;
            }
        }
        catch (OpenAPIParsingException e) {
            String detail = "Could not parse OpenAPI with title %s. Check syntax and references.".formatted(rec.api.getInfo().getTitle());
            log.warn(detail, (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).addSubType("openapi").flow(Interceptor.Flow.RESPONSE).detail(detail).exception(e).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        catch (Throwable t) {
            log.error("", t);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).addSubSee("generic").flow(Interceptor.Flow.RESPONSE).detail("Message could not be validated against OpenAPI cause of an error during validation. Please check the OpenAPI with title %s.".formatted(rec.api.getInfo().getTitle())).exception(t).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    protected String getMatchingBasePath(Exchange exc) {
        for (String basePath : this.apiProxy.getBasePaths().keySet()) {
            if (!exc.getRequest().getUri().startsWith(basePath)) continue;
            return basePath;
        }
        log.debug("Could not find matching base path for OpenAPI request {}. Returning empty basePath.", (Object)exc.getRequest().getUri());
        return null;
    }

    private ValidationErrors validateRequest(OpenAPIRecord rec, Exchange exc) throws IOException, ParseException {
        ValidationErrors errors = new ValidationErrors();
        if (!OpenAPIInterceptor.shouldValidate(rec.getApi(), "requests")) {
            return errors;
        }
        return new OpenAPIValidator(this.router.getUriFactory(), rec).validate(Utils.getOpenapiValidatorRequest(exc));
    }

    private ValidationErrors validateResponse(OpenAPIRecord rec, Exchange exc) throws IOException, ParseException {
        ValidationErrors errors = new ValidationErrors();
        if (!OpenAPIInterceptor.shouldValidate(rec.getApi(), "responses")) {
            return errors;
        }
        return new OpenAPIValidator(this.router.getUriFactory(), rec).validateResponse(Utils.getOpenapiValidatorRequest(exc), Utils.getOpenapiValidatorResponse(exc));
    }

    public boolean validationDetails(OpenAPI api) {
        if (api.getExtensions() == null) {
            return true;
        }
        Map xValidation = (Map)api.getExtensions().get("x-membrane-validation");
        if (xValidation == null) {
            return true;
        }
        Boolean validationDetails = (Boolean)xValidation.get("details");
        if (xValidation.get("details") == null) {
            return true;
        }
        return validationDetails;
    }

    public static boolean shouldValidate(OpenAPI api, String direction) {
        Map extensions = api.getExtensions();
        if (extensions == null) {
            return false;
        }
        Map<String, Boolean> xValidation = OpenAPIInterceptor.getxValidation(extensions);
        return xValidation != null && xValidation.get(direction) != false;
    }

    private static Map<String, Boolean> getxValidation(Map<String, Object> extensions) {
        return (Map)extensions.get("x-membrane-validation");
    }

    protected void setDestinationsFromOpenAPI(OpenAPIRecord rec, Exchange exc) {
        exc.getDestinations().clear();
        rec.api.getServers().forEach(server -> {
            URL url = OpenAPIInterceptor.getServerUrlFromOpenAPI(server);
            exc.setProperty("membrane.sni.server.name", url.getHost());
            exc.getDestinations().add(UriUtil.getUrlWithoutPath(url) + exc.getRequest().getUri());
        });
    }

    private static URL getServerUrlFromOpenAPI(Server server) {
        try {
            return new URL(server.getUrl());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse server address from OpenAPI " + server.getUrl());
        }
    }

    @Override
    public String getDisplayName() {
        return "openapi";
    }

    @Override
    public String getShortDescription() {
        return "Autoconfiguration from OpenAPI";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<thead><th>API</th><th>Base Paths</th><th>Properties</th></thead>");
        for (Map.Entry entry : this.apiProxy.getBasePaths().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).entrySet()) {
            OpenAPIRecord value = entry.getKey();
            List keys = entry.getValue();
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(value.api.getInfo().getTitle());
            sb.append("</td>");
            sb.append("<td>");
            keys.stream().sorted().forEach(keyList -> sb.append((String)keyList).append("<br />"));
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<b>SwaggerUI: </b>");
            sb.append("<a href='").append(this.buildSwaggerUrl(value.api)).append("'>").append(this.buildSwaggerUrl(value.api)).append("</a>");
            sb.append("<br /> <br />");
            sb.append("<b> Validation Configuration: </b>");
            sb.append("<br />");
            if (value.api.getExtensions() != null && value.api.getExtensions().get("x-membrane-validation") != null) {
                sb.append(this.buildValidationPropertiesDescription((Map)value.api.getExtensions().get("x-membrane-validation")));
            }
            sb.append("<br />");
            sb.append("<b>Server: </b>");
            value.getApi().getServers().stream().sorted(Comparator.comparing(Server::getUrl)).forEach(s -> sb.append("<br /> - <a href='").append(s.getUrl()).append("'>").append(s.getUrl()).append("</a>"));
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public String buildSwaggerUrl(OpenAPI api) {
        return "%s%s:%d%s%s".formatted(this.getSwaggerProtocol(this.getSwaggerHost()), this.getSwaggerHost(), this.getKey().getPort(), this.getSwaggerPath(), this.getSwaggerPath(api));
    }

    private String getSwaggerHost() {
        return !Objects.equals(this.getKey().getHost(), "*") ? this.getKey().getHost() : "localhost";
    }

    private String getSwaggerProtocol(String host) {
        if (!host.contains("http://") && !host.contains("https://")) {
            return this.router.getParentProxy(this).getProtocol();
        }
        return "";
    }

    private String getSwaggerPath() {
        return this.getKey().getPath() != null ? this.getKey().getPath() : "";
    }

    private String getSwaggerPath(OpenAPI api) {
        return "/api-docs/ui/" + (String)this.apiProxy.apiRecords.entrySet().stream().filter(d -> ((OpenAPIRecord)d.getValue()).api == api).findFirst().get().getKey();
    }

    private RuleKey getKey() {
        return this.router.getParentProxy(this).getKey();
    }

    private String buildValidationPropertiesDescription(Map<String, Object> props) {
        return "- Security: %s<br />\n- Requests: %s<br />\n- Responses: %s<br />\n- Details: %s<br />\nFor in-depth explanation of these properties visit <a href=\"https://www.membrane-api.io/openapi/configuration-and-validation/index.html#validation\"> here </a><br />\n".formatted(props.get("security"), props.get("requests"), props.get("responses"), props.get("details"));
    }

    private void createErrorResponse(Exchange exc, ValidationErrors errors, ValidationErrors.Direction direction, boolean validationDetails) {
        ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).title("OpenAPI message validation failed").addSubType("validation").statusCode(errors.get(0).getContext().getStatusCode()).flow(this.getFlowFromDirection(direction)).topLevel("validation", OpenAPIInterceptor.getErrorMap(errors, direction, validationDetails)).buildAndSetResponse(exc);
    }

    private Interceptor.Flow getFlowFromDirection(ValidationErrors.Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case ValidationErrors.Direction.REQUEST -> Interceptor.Flow.REQUEST;
            case ValidationErrors.Direction.RESPONSE -> Interceptor.Flow.RESPONSE;
        };
    }

    private static Map<String, Object> getErrorMap(ValidationErrors errors, ValidationErrors.Direction direction, boolean validationDetails) {
        if (validationDetails) {
            return errors.getErrorMessage(direction);
        }
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("error", "Message validation failed!");
        return m;
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_RESPONSE_FLOW;
    }
}

