/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.OpenAPIUtil;
import com.predic8.membrane.core.openapi.util.Utils;
import groovy.text.StreamingTemplateEngine;
import groovy.text.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class OpenAPIPublisher {
    public static final String PATH = "/api-docs";
    public static final String PATH_UI = "/api-docs/ui";
    private static final Pattern PATTERN_META = Pattern.compile("/api-docs?/(.+)");
    private static final Pattern PATTERN_UI = Pattern.compile("/api-docs?/ui/(.+)");
    private final Template swaggerUiHtmlTemplate;
    private final Template apiOverviewHtmlTemplate;
    private final ObjectMapper om = new ObjectMapper();
    private final ObjectWriter ow = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private final ObjectMapper omYaml = ObjectMapperFactory.createYaml();
    protected Map<String, OpenAPIRecord> apis;

    public OpenAPIPublisher(Map<String, OpenAPIRecord> apis) throws IOException, ClassNotFoundException {
        this.apis = apis;
        this.swaggerUiHtmlTemplate = this.createTemplate("/openapi/swagger-ui.html");
        this.apiOverviewHtmlTemplate = this.createTemplate("/openapi/overview.html");
    }

    Outcome handleSwaggerUi(Exchange exc) {
        Matcher m = PATTERN_UI.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            ProblemDetails.user(false, "openapi-publisher").title("No OpenAPI document id").addSubType("openapi").statusCode(404).addSubSee("wrong-id").detail("Please specify an id of an OpenAPI document. Path should match this pattern: /api-docs/ui/<<id>>").buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        String id = m.group(1);
        OpenAPIRecord record = this.apis.get(id);
        if (record == null) {
            return this.returnNoFound(exc, id);
        }
        exc.setResponse(Response.ok().contentType("text/html;charset=UTF-8").body(this.renderSwaggerUITemplate(id, record.api)).build());
        return Outcome.RETURN;
    }

    Outcome handleOverviewOpenAPIDoc(Exchange exc, Router router, Logger log) throws IOException, URISyntaxException {
        Matcher m = PATTERN_META.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            if (this.acceptsHtmlExplicit(exc)) {
                return this.returnHtmlOverview(exc, router);
            }
            return this.returnJsonOverview(exc, log);
        }
        String id = m.group(1);
        OpenAPIRecord rec = this.apis.get(id);
        if (rec == null) {
            return this.returnNoFound(exc, id);
        }
        return this.returnOpenApiAsYaml(exc, rec, router);
    }

    private boolean acceptsHtmlExplicit(Exchange exc) {
        if (exc.getRequest().getHeader().getAccept() == null) {
            return false;
        }
        return exc.getRequest().getHeader().getAccept().contains("html");
    }

    private Outcome returnJsonOverview(Exchange exc, Logger log) throws JsonProcessingException {
        exc.setResponse(Response.ok().contentType("application/json").body(this.ow.writeValueAsBytes((Object)this.createDictionaryOfAPIs(log))).build());
        return Outcome.RETURN;
    }

    private Outcome returnHtmlOverview(Exchange exc, Router router) {
        exc.setResponse(Response.ok().contentType("text/html;charset=UTF-8").body(this.renderOverviewTemplate(router)).build());
        return Outcome.RETURN;
    }

    private Outcome returnNoFound(Exchange exc, String id) {
        ProblemDetails.user(false, "openapi-publisher").title("OpenAPI not found.").statusCode(404).addSubType("openapi").addSubSee("wrong-id").detail("OpenAPI document with the id %s not found.".formatted(id)).buildAndSetResponse(exc);
        return Outcome.RETURN;
    }

    private Outcome returnOpenApiAsYaml(Exchange exc, OpenAPIRecord rec, Router router) throws IOException, URISyntaxException {
        exc.setResponse(Response.ok().yaml().body(this.omYaml.writeValueAsBytes((Object)rec.rewriteOpenAPI(exc, router.getUriFactory()))).build());
        return Outcome.RETURN;
    }

    private Template createTemplate(String filePath) throws ClassNotFoundException, IOException {
        return new StreamingTemplateEngine().createTemplate((Reader)new InputStreamReader(Objects.requireNonNull(Utils.getResourceAsStream(this, filePath))));
    }

    private String renderOverviewTemplate(Router router) {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("apis", this.apis);
        tempCtx.put("pathUi", PATH_UI);
        tempCtx.put("path", PATH);
        tempCtx.put("uriFactory", router.getUriFactory());
        return this.apiOverviewHtmlTemplate.make(tempCtx).toString();
    }

    private String renderSwaggerUITemplate(String id, OpenAPI api) {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("openApiUrl", "/api-docs/" + id);
        tempCtx.put("openApiTitle", api.getInfo().getTitle());
        return this.swaggerUiHtmlTemplate.make(tempCtx).toString();
    }

    private ObjectNode createDictionaryOfAPIs(Logger log) {
        ObjectNode top = this.om.createObjectNode();
        for (Map.Entry<String, OpenAPIRecord> api : this.apis.entrySet()) {
            ObjectNode apiDetails = top.putObject(api.getKey());
            JsonNode node = api.getValue().node;
            apiDetails.put("openapi", this.getSpecVersion(node, log));
            apiDetails.put("title", node.get("info").get("title").asText());
            apiDetails.put("version", node.get("info").get("version").asText());
            apiDetails.put("openapi_link", "/api-docs/" + api.getKey());
            apiDetails.put("ui_link", "/api-docs/ui/" + api.getKey());
        }
        return top;
    }

    private String getSpecVersion(JsonNode node, Logger log) {
        if (OpenAPIUtil.isSwagger2(node)) {
            return node.get("swagger").asText();
        }
        if (OpenAPIUtil.isOpenAPI3(node)) {
            return node.get("openapi").asText();
        }
        log.info("Unknown OpenAPI version ignoring {}", (Object)node);
        return "?";
    }
}

