/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.OpenAPIUtil;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URIFactory;
import groovy.text.StreamingTemplateEngine;
import groovy.text.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="openapiPublisher")
public class OpenAPIPublisherInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIPublisherInterceptor.class.getName());
    private final ObjectMapper om = new ObjectMapper();
    private final ObjectWriter ow = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private final ObjectMapper omYaml = ObjectMapperFactory.createYaml();
    public static final String PATH = "/api-docs";
    public static final String PATH_UI = "/api-docs/ui";
    private static final Pattern PATTERN_META = Pattern.compile("/api-docs?/(.+)");
    private static final Pattern PATTERN_UI = Pattern.compile("/api-docs?/ui/(.+)");
    protected Map<String, OpenAPIRecord> apis;
    private Template swaggerUiHtmlTemplate;
    private Template apiOverviewHtmlTemplate;

    public OpenAPIPublisherInterceptor() {
    }

    public OpenAPIPublisherInterceptor(Map<String, OpenAPIRecord> apis) {
        this.apis = apis;
    }

    @Override
    public void init() {
        Proxy proxy;
        super.init();
        if (this.apis == null && (proxy = this.router.getParentProxy(this)) instanceof APIProxy) {
            APIProxy ap = (APIProxy)proxy;
            this.apis = ap.apiRecords;
        }
        this.swaggerUiHtmlTemplate = this.createHTMLPageTemplate("/openapi/swagger-ui.html");
        this.checkServerPaths();
        this.apiOverviewHtmlTemplate = this.createHTMLPageTemplate("/openapi/overview.html");
    }

    private Template createHTMLPageTemplate(String filePath) {
        try {
            return new StreamingTemplateEngine().createTemplate((Reader)new InputStreamReader(Objects.requireNonNull(Utils.getResourceAsStream(this, filePath))));
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create Swagger UI or overview page template from: %s".formatted(filePath), e);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (exc.getRequest().getUri().matches(String.valueOf(PATTERN_UI))) {
            return this.handleSwaggerUi(exc);
        }
        if (!exc.getRequest().getUri().startsWith("/api-doc")) {
            return Outcome.CONTINUE;
        }
        try {
            return this.handleOverviewOpenAPIDoc(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Error handling OpenAPI overview!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private Outcome handleOverviewOpenAPIDoc(Exchange exc) throws IOException, URISyntaxException {
        Matcher m = PATTERN_META.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            if (this.acceptsHtmlExplicit(exc)) {
                return this.returnHtmlOverview(exc);
            }
            return this.returnJsonOverview(exc);
        }
        String id = m.group(1);
        OpenAPIRecord rec = this.apis.get(id);
        if (rec == null) {
            return this.returnNoFound(exc, id);
        }
        return this.returnOpenApiAsYaml(exc, rec);
    }

    private Outcome returnJsonOverview(Exchange exc) throws JsonProcessingException {
        exc.setResponse(Response.ok().contentType("application/json").body(this.ow.writeValueAsBytes((Object)this.createDictionaryOfAPIs())).build());
        return Outcome.RETURN;
    }

    private Outcome returnHtmlOverview(Exchange exc) {
        exc.setResponse(Response.ok().contentType("text/html;charset=UTF-8").body(this.renderOverviewTemplate()).build());
        return Outcome.RETURN;
    }

    private Outcome returnNoFound(Exchange exc, String id) {
        ProblemDetails.user(false, this.getDisplayName()).title("OpenAPI not found").statusCode(404).addSubType("openapi").addSubSee("wrong-id").detail("OpenAPI document with the id %s not found.".formatted(id)).topLevel("id", id).buildAndSetResponse(exc);
        return Outcome.RETURN;
    }

    private Outcome returnOpenApiAsYaml(Exchange exc, OpenAPIRecord rec) throws IOException, URISyntaxException {
        exc.setResponse(Response.ok().yaml().body(this.omYaml.writeValueAsBytes((Object)rec.rewriteOpenAPI(exc, this.getRouter().getUriFactory()))).build());
        return Outcome.RETURN;
    }

    private Outcome handleSwaggerUi(Exchange exc) {
        Matcher m = PATTERN_UI.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            ProblemDetails.user(false, this.getDisplayName()).title("No OpenAPI document id").statusCode(404).addSubType("openapi").addSubSee("wrong-id").detail("Please specify an id of an OpenAPI document. Path should match this pattern: /api-docs/ui/<<id>>").buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        String id = m.group(1);
        log.info("OpenAPI with id {} requested", (Object)id);
        OpenAPIRecord record = this.apis.get(id);
        if (record == null) {
            return this.returnNoFound(exc, id);
        }
        exc.setResponse(Response.ok().contentType("text/html;charset=UTF-8").body(this.renderSwaggerUITemplate(id, record.api)).build());
        return Outcome.RETURN;
    }

    private String renderOverviewTemplate() {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("apis", this.apis);
        tempCtx.put("pathUi", PATH_UI);
        tempCtx.put("path", PATH);
        tempCtx.put("uriFactory", this.router.getUriFactory());
        return this.apiOverviewHtmlTemplate.make(tempCtx).toString();
    }

    private String renderSwaggerUITemplate(String id, OpenAPI api) {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("openApiUrl", "/api-docs/" + id);
        tempCtx.put("openApiTitle", api.getInfo().getTitle());
        return this.swaggerUiHtmlTemplate.make(tempCtx).toString();
    }

    private ObjectNode createDictionaryOfAPIs() {
        ObjectNode top = this.om.createObjectNode();
        for (Map.Entry<String, OpenAPIRecord> api : this.apis.entrySet()) {
            ObjectNode apiDetails = top.putObject(api.getKey());
            JsonNode node = api.getValue().node;
            apiDetails.put("openapi", this.getSpecVersion(node));
            apiDetails.put("title", node.get("info").get("title").asText());
            apiDetails.put("version", node.get("info").get("version").asText());
            apiDetails.put("openapi_link", "/api-docs/" + api.getKey());
            apiDetails.put("ui_link", "/api-docs/ui/" + api.getKey());
        }
        return top;
    }

    private String getSpecVersion(JsonNode node) {
        if (OpenAPIUtil.isSwagger2(node)) {
            return node.get("swagger").asText();
        }
        if (OpenAPIUtil.isOpenAPI3(node)) {
            return node.get("openapi").asText();
        }
        log.info("Unknown OpenAPI version ignoring {}", (Object)node);
        return "?";
    }

    private boolean acceptsHtmlExplicit(Exchange exc) {
        if (exc.getRequest().getHeader().getAccept() == null) {
            return false;
        }
        return exc.getRequest().getHeader().getAccept().contains("html");
    }

    @Override
    public String getShortDescription() {
        return "Publishes the OpenAPI description and Swagger UI.";
    }

    private void checkServerPaths() {
        if (this.apis.size() <= 1) {
            return;
        }
        this.apis.values().stream().filter(this::hasPathMatchingAllRequests).forEach(apiRecord -> log.warn("API {} contains URLs with '/' matching all requests. This might cause routing to the wrong API!", (Object)apiRecord.api.getInfo().getTitle()));
    }

    private boolean hasPathMatchingAllRequests(OpenAPIRecord apiRecord) {
        return apiRecord.api.getServers().stream().map(server -> {
            try {
                return UriUtil.getPathFromURL(new URIFactory(), server.getUrl());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).anyMatch(serverUrl -> serverUrl == null || serverUrl.isEmpty() || serverUrl.equals("/"));
    }

    @Override
    public String getDisplayName() {
        return "openapi publisher";
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_FLOW;
    }
}

