/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPISpec;
import com.predic8.membrane.core.openapi.util.OpenAPIUtil;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URIFactory;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.net.URISyntaxException;

public class OpenAPIRecord {
    OpenAPI api;
    JsonNode node;
    OpenAPISpec spec;
    String version;

    public OpenAPIRecord() {
    }

    public OpenAPIRecord(OpenAPI api, OpenAPISpec spec) {
        this.api = api;
        try {
            this.node = OpenAPIUtil.convert2Json(api);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot convert OpenAPI to JSON.\n\nOpenAPI:\n%s\n".formatted(api), e);
        }
        this.spec = spec;
        this.version = api.getSpecVersion().name();
    }

    public JsonNode rewriteOpenAPI(Exchange exc, URIFactory uriFactory) throws URISyntaxException {
        return this.spec.getRewrite().rewrite(this, exc, uriFactory);
    }

    public OpenAPI getApi() {
        return this.api;
    }

    public OpenAPISpec getSpec() {
        return this.spec;
    }
}

