/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.openapi.OpenAPIParsingException;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPISpec;
import com.predic8.membrane.core.openapi.util.OpenAPIUtil;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.FileUtil;
import com.predic8.membrane.core.util.URIUtil;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIRecordFactory {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIRecordFactory.class.getName());
    private static final ObjectMapper omYaml = ObjectMapperFactory.createYaml();
    private final Router router;

    public OpenAPIRecordFactory(Router router) {
        this.router = router;
    }

    public Map<String, OpenAPIRecord> create(Collection<OpenAPISpec> specs) {
        LinkedHashMap<String, OpenAPIRecord> apiRecords = new LinkedHashMap<String, OpenAPIRecord>();
        for (OpenAPISpec spec : specs) {
            this.addOpenApisFromLocation(apiRecords, spec);
            this.addOpenApisFromDirectory(apiRecords, spec);
        }
        return apiRecords;
    }

    private void addOpenApisFromDirectory(Map<String, OpenAPIRecord> apiRecords, OpenAPISpec spec) {
        if (spec.dir == null) {
            return;
        }
        log.info("Parsing specs from dir {}", (Object)spec.dir);
        File[] files = this.getOpenAPIFiles(spec.dir);
        if (files == null) {
            log.warn("Directory {} does not contain any OpenAPI documents.", (Object)spec.dir);
            return;
        }
        for (File file : files) {
            log.info("Parsing spec {}", (Object)file);
            OpenAPISpec fileSpec = spec.clone();
            fileSpec.setLocation(spec.dir + "/" + file.getName());
            OpenAPIRecord rec = this.create(fileSpec, file);
            apiRecords.put(this.getUniqueId(apiRecords, rec), rec);
        }
    }

    private void addOpenApisFromLocation(Map<String, OpenAPIRecord> apiRecords, OpenAPISpec spec) {
        if (spec.location == null) {
            return;
        }
        try {
            log.debug("Parsing spec {}", (Object)spec.location);
            OpenAPIRecord rec = this.create(spec);
            apiRecords.put(this.getUniqueId(apiRecords, rec), rec);
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (root instanceof UnknownHostException) {
                throw new ConfigurationException(String.format("Error accessing OpenAPI specification from location: %s\n\nThe hostname cannot be resolved to an IP address. Maybe the internet\nis not reachable or a proxy server configuration is needed.\n\nHave a look at: ...\n", spec.location));
            }
            if (root instanceof OpenAPIParsingException) {
                OpenAPIParsingException pe = (OpenAPIParsingException)root;
                throw new ConfigurationException(String.format("Could not read or parse OpenAPI Document from location: %s\n\nHave a look at your proxies.xml configuration.\n", pe.getLocation()), pe);
            }
            if (root instanceof FileNotFoundException) {
                FileNotFoundException fnf = (FileNotFoundException)root;
                throw new ConfigurationException("Cannot read OpenAPI specification from location: " + spec.location, fnf);
            }
            String msg = "While parsing spec %s .".formatted(spec.location);
            log.error(msg, (Throwable)e);
            throw new ConfigurationException(msg, e);
        }
    }

    String getUniqueId(Map<String, OpenAPIRecord> apiRecords, OpenAPIRecord rec) {
        Object id = OpenAPIUtil.getIdFromAPI(rec.api);
        if (apiRecords.get(id) != null) {
            log.warn("There are multiple OpenAPI documents with the id {}. The id is computed from the title {} and version {}. Please make sure that the documents are different or use the x-membrane-id field.", new Object[]{id, rec.api.getInfo().getTitle(), rec.api.getInfo().getVersion()});
            while (apiRecords.get(id) != null) {
                id = (String)id + "-0";
            }
            log.warn("Changing the id to {} in order to make them unique.", id);
        }
        return id;
    }

    private OpenAPIRecord create(OpenAPISpec spec) {
        OpenAPIRecord record = new OpenAPIRecord(this.getOpenAPI(spec), spec);
        this.setExtensionOnAPI(spec, record.api);
        return record;
    }

    private OpenAPIRecord create(OpenAPISpec spec, File file) {
        OpenAPIRecord record = new OpenAPIRecord(this.parseFileAsOpenAPI(file), spec);
        this.setExtensionOnAPI(spec, record.api);
        return record;
    }

    private OpenAPI getOpenAPI(OpenAPISpec spec) {
        String path = this.resolve(spec.location);
        try {
            OpenAPI openAPI = new OpenAPIParser().readLocation(OpenAPIRecordFactory.convertPathToFileUriPathIfNeeded(path), null, OpenAPIRecordFactory.getParseOptions()).getOpenAPI();
            this.addConversionNoticeIfSwagger2(openAPI, omYaml.readTree(this.getInputStreamForLocation(spec.location)));
            return openAPI;
        }
        catch (IOException e) {
            throw new OpenAPIParsingException("Could not read OpenAPI: " + e.getMessage(), path);
        }
    }

    @NotNull
    private static String convertPathToFileUriPathIfNeeded(String path) {
        if (!(path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:"))) {
            path = URIUtil.convertPath2FilePathString(path);
        }
        return path;
    }

    private InputStream getInputStreamForLocation(String location) throws ResourceRetrievalException {
        return this.router.getResolverMap().resolve(ResolverMap.combine(this.router.getBaseLocation(), location));
    }

    private OpenAPI parseFileAsOpenAPI(File oaFile) {
        try {
            JsonNode node = omYaml.readTree(oaFile);
            OpenAPI api = new OpenAPIParser().readContents(FileUtil.readInputStream(new FileInputStream(oaFile)), null, OpenAPIRecordFactory.getParseOptions()).getOpenAPI();
            this.addConversionNoticeIfSwagger2(api, node);
            return api;
        }
        catch (IOException e) {
            throw new OpenAPIParsingException("Could not read OpenAPI file: " + e.getMessage(), oaFile.getPath());
        }
    }

    private void addConversionNoticeIfSwagger2(OpenAPI api, JsonNode node) {
        if (!OpenAPIUtil.isSwagger2(node) || api.getInfo() == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(api.getInfo().getDescription());
        if (api.getInfo().getDescription() != null) {
            builder.append("\n\n");
        }
        builder.append("***Note:*** *This OpenAPI description was converted from Swagger 2 to OAS 3 by Membrane API Gateway!*");
        api.getInfo().setDescription(builder.toString());
    }

    private String resolve(String filepath) {
        return ResolverMap.combine(this.router.getBaseLocation(), filepath);
    }

    @NotNull
    private static ParseOptions getParseOptions() {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        return parseOptions;
    }

    private void setExtensionOnAPI(OpenAPISpec spec, OpenAPI api) {
        if (api.getExtensions() == null) {
            api.setExtensions(new HashMap());
        }
        api.getExtensions().put("x-membrane-validation", this.updateExtension(OpenAPIRecordFactory.getXValidationExtension(api), spec));
    }

    private static Map<String, Object> getXValidationExtension(OpenAPI api) {
        if (api.getExtensions().get("x-membrane-validation") != null) {
            return (Map)api.getExtensions().get("x-membrane-validation");
        }
        HashMap<String, Object> extension = new HashMap<String, Object>();
        extension.put("requests", false);
        extension.put("responses", false);
        extension.put("details", true);
        return extension;
    }

    private Map<String, Object> updateExtension(Map<String, Object> extension, OpenAPISpec spec) {
        if (spec.validationDetails != OpenAPISpec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("details", this.toYesNo(spec.validationDetails));
        }
        if (spec.validateRequests != OpenAPISpec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("requests", this.toYesNo(spec.validateRequests));
        }
        if (spec.validateResponses != OpenAPISpec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("responses", this.toYesNo(spec.validateResponses));
        }
        if (spec.validateSecurity != OpenAPISpec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("security", this.toYesNo(spec.validateSecurity));
        }
        if (spec.validateSecurity == OpenAPISpec.YesNoOpenAPIOption.YES && spec.validateRequests == OpenAPISpec.YesNoOpenAPIOption.NO) {
            log.warn("Automatically enabled request validation; which is required by security validation.");
        }
        extension.putIfAbsent("security", false);
        if (extension.get("security").equals(true)) {
            extension.put("requests", true);
        }
        extension.putIfAbsent("requests", false);
        extension.putIfAbsent("responses", false);
        return extension;
    }

    private boolean toYesNo(OpenAPISpec.YesNoOpenAPIOption option) {
        return option == OpenAPISpec.YesNoOpenAPIOption.YES;
    }

    private File[] getOpenAPIFiles(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new ConfigurationException(String.format("Cannot open directory %s. Please check the OpenAPI configuration of your API.", dir.getAbsolutePath()));
        }
        return dir.listFiles((d, name) -> name.endsWith(".yml") || name.endsWith(".yaml") || name.endsWith(".json"));
    }
}

