/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.util.URIFactory;
import java.net.URISyntaxException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="rewrite", topLevel=false)
public class Rewrite
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger((String)Rewrite.class.getName());
    Integer port;
    String protocol;
    String host;
    String basePath;

    public Rewrite clone() {
        try {
            return (Rewrite)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Should never happen", e);
        }
    }

    public JsonNode rewrite(OpenAPIRecord rec, Exchange exc, URIFactory uriFactory) throws URISyntaxException {
        return this.rewriteOpenAPI3(exc, uriFactory, rec.node);
    }

    private JsonNode rewriteOpenAPI3(Exchange exc, URIFactory uriFactory, JsonNode node) throws URISyntaxException {
        JsonNode rewritten = node.deepCopy();
        for (JsonNode server : rewritten.get("servers")) {
            this.rewriteServerEntry(exc, uriFactory, server);
        }
        return rewritten;
    }

    private void rewriteServerEntry(Exchange exc, URIFactory uriFactory, JsonNode server) throws URISyntaxException {
        String serverUrl = server.get("url").asText();
        String rewritten = this.rewriteUrl(exc, serverUrl, uriFactory);
        ((ObjectNode)server).put("url", rewritten);
        log.debug("Rewriting {} to {}", (Object)serverUrl, (Object)rewritten);
    }

    protected String rewriteUrl(Exchange exc, String url, URIFactory uriFactory) throws URISyntaxException {
        return UriUtil.rewrite(uriFactory, this.rewriteUrl(url), this.rewriteProtocol(exc.getInboundProtocol()), this.rewriteHost(exc.getOriginalHostHeaderHost()), this.rewritePort(exc.getOriginalHostHeaderPort()));
    }

    private JsonNode rewriteSwagger2(Exchange exc, JsonNode node) {
        JsonNode rewritten = node.deepCopy();
        this.rewriteHostAndPortSwagger2(exc, rewritten);
        this.rewriteSchemeSwagger2(exc, rewritten);
        return rewritten;
    }

    private void rewriteSchemeSwagger2(Exchange exc, JsonNode node) {
        ArrayNode schemes = ((ObjectNode)node).putArray("schemes");
        schemes.add(exc.getInboundProtocol());
    }

    private void rewriteHostAndPortSwagger2(Exchange exc, JsonNode rewrittenJson) {
        JsonNode host = rewrittenJson.get("host");
        if (host == null) {
            return;
        }
        String rewrittenHost = this.getRewrittenHostAndPortSwagger2(exc);
        ((ObjectNode)rewrittenJson).put("host", rewrittenHost);
        log.debug("Rewriting {} to {}", (Object)host, (Object)rewrittenHost);
    }

    protected String getRewrittenHostAndPortSwagger2(Exchange exc) {
        return this.rewriteHost(exc.getOriginalHostHeaderHost()) + ":" + this.rewritePort(exc.getOriginalHostHeaderPort());
    }

    public String rewriteProtocol(String protocol) {
        return Objects.requireNonNullElse(this.protocol, protocol);
    }

    public String rewriteHost(String host) {
        return Objects.requireNonNullElse(this.host, host);
    }

    public String rewriteUrl(String url) {
        return Objects.requireNonNullElse(this.basePath, url);
    }

    public String rewritePort(String port) {
        if (this.port != null) {
            return this.port.toString();
        }
        return port;
    }

    public Integer getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @MCAttribute
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    @MCAttribute
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

