/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import java.util.Map;
import java.util.Objects;

public class ValidationStatsKey {
    private final String method;
    private final String path;
    private final String uriTemplate;
    private final String schemaType;
    private final String complexType;
    private final String validatedEntityType;
    private final String validatedEntity;
    private final String jsonpointer;
    private final Map<String, String> labels;

    ValidationStatsKey(ValidationContext vc) {
        this.method = vc.getMethod();
        this.path = vc.getPath();
        this.uriTemplate = ValidationStatsKey.valueOrEmptyString(vc.getUriTemplate());
        this.schemaType = ValidationStatsKey.valueOrEmptyString(vc.getSchemaType());
        this.complexType = ValidationStatsKey.valueOrEmptyString(vc.getComplexType());
        this.validatedEntityType = vc.getValidatedEntityType() != null ? vc.getValidatedEntityType().name() : "";
        this.validatedEntity = ValidationStatsKey.valueOrEmptyString(vc.getValidatedEntity());
        this.jsonpointer = vc.getJSONpointer();
        this.labels = new ImmutableMap.Builder().put((Object)"method", (Object)this.method).put((Object)"path", (Object)this.path).put((Object)"uritemplate", (Object)this.uriTemplate).put((Object)"schematype", (Object)this.schemaType).put((Object)"complextype", (Object)this.complexType).put((Object)"entitytype", (Object)this.validatedEntityType).put((Object)"entity", (Object)this.validatedEntity).put((Object)"jsonpointer", (Object)this.jsonpointer).build();
    }

    private static String valueOrEmptyString(String v) {
        return v == null ? "" : v;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationStatsKey that = (ValidationStatsKey)o;
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.uriTemplate, that.uriTemplate)) {
            return false;
        }
        if (!Objects.equals(this.schemaType, that.schemaType)) {
            return false;
        }
        if (!Objects.equals(this.complexType, that.complexType)) {
            return false;
        }
        if (!Objects.equals(this.validatedEntityType, that.validatedEntityType)) {
            return false;
        }
        if (!Objects.equals(this.validatedEntity, that.validatedEntity)) {
            return false;
        }
        return Objects.equals(this.jsonpointer, that.jsonpointer);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.uriTemplate != null ? this.uriTemplate.hashCode() : 0);
        result = 31 * result + (this.schemaType != null ? this.schemaType.hashCode() : 0);
        result = 31 * result + (this.complexType != null ? this.complexType.hashCode() : 0);
        result = 31 * result + (this.validatedEntityType != null ? this.validatedEntityType.hashCode() : 0);
        result = 31 * result + (this.validatedEntity != null ? this.validatedEntity.hashCode() : 0);
        result = 31 * result + (this.jsonpointer != null ? this.jsonpointer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ValidationStatsKey{method='" + this.method + "', path='" + this.path + "', uriTemplate='" + this.uriTemplate + "', schemaType='" + this.schemaType + "', complexType='" + this.complexType + "', validatedEntityType='" + this.validatedEntityType + "', validatedEntity='" + this.validatedEntity + "', jsonpointer='" + this.jsonpointer + "'}";
    }
}

