/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.openapi.util.Utils;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIUtil {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIUtil.class.getName());
    private static final ObjectMapper omYaml = ObjectMapperFactory.createYaml();

    public static String getIdFromAPI(OpenAPI api) {
        String id;
        if (api.getInfo().getExtensions() != null && (id = (String)api.getInfo().getExtensions().get("x-membrane-id")) != null) {
            return Utils.normalizeForId(id + OpenAPIUtil.getVersionSuffix(api));
        }
        return Utils.normalizeForId(api.getInfo().getTitle() + "-v" + api.getInfo().getVersion());
    }

    private static String getVersionSuffix(OpenAPI api) {
        return "-v" + api.getInfo().getVersion();
    }

    public static String getOpenAPIVersion(JsonNode node) {
        if (OpenAPIUtil.isSwagger2(node)) {
            return node.get("swagger").asText();
        }
        if (OpenAPIUtil.isOpenAPI3(node)) {
            return node.get("openapi").asText();
        }
        log.info("Cannot detect OpenAPI version.");
        return "?";
    }

    public static boolean isOpenAPI3(JsonNode node) {
        return node.get("openapi") != null && node.get("openapi").asText().startsWith("3");
    }

    public static boolean isSwagger2(JsonNode node) {
        return node.get("swagger") != null && node.get("swagger").asText().startsWith("2");
    }

    public static JsonNode convert2Json(OpenAPI api) throws IOException {
        return omYaml.readTree(Json31.mapper().writeValueAsBytes((Object)api));
    }
}

