/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.predic8.membrane.core.openapi.OpenAPIParsingException;
import com.predic8.membrane.core.openapi.util.ObjectHolder;
import com.predic8.membrane.core.openapi.util.Utils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;

public class SchemaUtil {
    public static Schema getSchemaFromRef(OpenAPI api, Schema schema) {
        Components components = api.getComponents();
        if (components == null) {
            throw new OpenAPIParsingException("OpenAPI with title %s has no #/components field.");
        }
        Map schemas = components.getSchemas();
        if (schemas == null) {
            throw new OpenAPIParsingException("OpenAPI with title %s has no #/components/schemas field.");
        }
        ObjectHolder oh = new ObjectHolder();
        schemas.forEach((schemaName, refSchema) -> {
            if (schemaName.equals(SchemaUtil.getSchemaNameFromRef(schema))) {
                oh.setValue(refSchema);
            }
        });
        return (Schema)oh.getValue();
    }

    public static String getSchemaNameFromRef(Schema schema) {
        return Utils.getComponentLocalNameFromRef(schema.get$ref());
    }
}

