/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class UriTemplateMatcher {
    public static final String PARAM_NAME_REGEX = "\\{([^/]+?)}";
    public static final String URI_PARAM_MATCH = "([^/]+)";
    private static final Pattern PARAM_NAME_REGEX_PATTERN = Pattern.compile("\\{([^/]+?)}");

    public static Map<String, String> matchTemplate(String template, String uri) throws PathDoesNotMatchException {
        if (template == null || uri == null) {
            return null;
        }
        Matcher parameters = UriTemplateMatcher.getTemplateMatcher(template, uri);
        if (!parameters.matches()) {
            throw new PathDoesNotMatchException();
        }
        List<String> names = UriTemplateMatcher.getParameterNames(template);
        return IntStream.range(0, names.size()).boxed().collect(Collectors.toMap(names::get, i -> URLDecoder.decode(parameters.group(i + 1), StandardCharsets.UTF_8)));
    }

    static List<String> getParameterNames(String uriTemplate) {
        return UriTemplateMatcher.getNameMatcher(UriTemplateMatcher.normalizePath(uriTemplate)).results().map(r -> r.group(1)).toList();
    }

    @NotNull
    private static Matcher getTemplateMatcher(String template, String path) {
        return Pattern.compile(UriTemplateMatcher.prepareTemplate(UriTemplateMatcher.normalizePath(template))).matcher(UriTemplateMatcher.normalizePath(path));
    }

    @NotNull
    static Matcher getNameMatcher(String normalizedTemplate) {
        return PARAM_NAME_REGEX_PATTERN.matcher(normalizedTemplate);
    }

    static String prepareTemplate(String template) {
        return template.replaceAll(PARAM_NAME_REGEX, URI_PARAM_MATCH);
    }

    static String normalizePath(String path) {
        String normalizedPath = path.split("\\?")[0];
        return normalizedPath.endsWith("/") ? normalizedPath : normalizedPath + "/";
    }
}

