/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.predic8.membrane.core.util.URIFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;

public class UriUtil {
    public static String normalizeUri(String s) {
        return s.replaceAll("/+", "/");
    }

    public static String trimQueryString(String path) {
        int idx = path.indexOf(63);
        if (idx == -1) {
            return path;
        }
        return path.substring(0, path.indexOf(63));
    }

    public static String trimTrailingSlash(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getUrlWithoutPath(URL url) {
        StringBuilder urlWithoutPath = new StringBuilder();
        if (url.getProtocol() != null) {
            urlWithoutPath.append(url.getProtocol()).append("://");
        }
        if (url.getHost() != null) {
            urlWithoutPath.append(url.getHost());
        }
        urlWithoutPath.append(UriUtil.getPortString(url));
        return urlWithoutPath.toString();
    }

    private static String getPortString(URL url) {
        if (url.getPort() == 80 && url.getProtocol().equals("http")) {
            return "";
        }
        if (url.getPort() == 443 && url.getProtocol().equals("https")) {
            return "";
        }
        if (url.getPort() == -1) {
            return "";
        }
        return ":" + url.getPort();
    }

    public static String rewrite(URIFactory uriFactory, String url, String scheme, String host, String port) throws URISyntaxException {
        String path;
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(host);
        if (UriUtil.nonDefaultPort(scheme, port)) {
            sb.append(":");
            sb.append(port);
        }
        if ((path = UriUtil.getPathFromURL(uriFactory, url)) != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    private static boolean nonDefaultPort(String scheme, String port) {
        if (port.isBlank()) {
            return false;
        }
        return !(Objects.equals(port, "80") && scheme.equals("http") || Objects.equals(port, "443") && scheme.equals("https"));
    }

    public static String getPathFromURL(URIFactory factory, String url) throws URISyntaxException {
        return factory.create(url).getPath();
    }
}

