/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.MediaTypeUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;

public abstract class AbstractBodyValidator<T extends Message<? extends Body, ?>> {
    protected OpenAPI api;

    public abstract int getDefaultStatusCode();

    public abstract String getMessageName();

    public AbstractBodyValidator(OpenAPI api) {
        this.api = api;
    }

    protected ValidationErrors validateBodyAccordingToMediaType(ValidationContext ctx, String mediaType, MediaType mediaTypeObj, Message<?, ?> message) {
        ValidationErrors errors = new ValidationErrors();
        if (MimeType.APPLICATION_JSON_CONTENT_TYPE.match(mediaType)) {
            if (mediaTypeObj.getSchema().get$ref() != null) {
                ctx.schemaType(mediaTypeObj.getSchema().get$ref());
            }
            errors.add(new SchemaValidator(this.api, mediaTypeObj.getSchema()).validate(ctx, message.getBody()));
        } else if (MimeType.isXML(mediaType)) {
            errors.add(ctx, "Validation of XML messages is not implemented yet!");
        } else if (MimeType.isWWWFormUrlEncoded(mediaType)) {
            errors.add(ctx, "Validation of 'application/x-www-form-urlencoded' messages is not implemented yet!");
        }
        return errors;
    }

    protected ValidationErrors validateContentTypeHeader(ValidationContext ctx, Message<?, ?> message) {
        ValidationErrors errors = new ValidationErrors();
        if (message.getMediaType() == null) {
            errors.add(ctx.statusCode(this.getDefaultStatusCode()), this.getMessageName() + " has a body, but no Content-Type header.");
            return errors;
        }
        if (message.getMediaType().getBaseType().equals("*") || message.getMediaType().getSubType().equals("*")) {
            errors.add(ctx.statusCode(this.getDefaultStatusCode()), "Content-Type %s is not concrete.".formatted(message.getMediaType()));
        }
        return errors;
    }

    protected ValidationErrors validateMediaTypeForMessageType(ValidationContext ctx, String mediaType, MediaType mediaTypeObj, Message<?, ?> response) {
        ValidationErrors errors = new ValidationErrors();
        if (!response.isOfMediaType(mediaType)) {
            errors.add(ctx.entityType(ValidationContext.ValidatedEntityType.MEDIA_TYPE).entity(response.getMediaType().toString()), String.format("Message has media type %s instead of the expected type %s.", response.getMediaType(), mediaType));
            return errors;
        }
        errors.add(this.validateBodyAccordingToMediaType(ctx.statusCode(this.getDefaultStatusCode()), mediaType, mediaTypeObj, response));
        return errors;
    }

    protected ValidationErrors validateBodyInternal(ValidationContext ctx, Message<?, ?> msg, Content content) {
        String mostSpecificMediaType;
        if (content == null) {
            return null;
        }
        ValidationErrors errors = this.validateContentTypeHeader(ctx.entityType(ValidationContext.ValidatedEntityType.BODY), msg);
        if (!errors.isEmpty()) {
            return errors;
        }
        try {
            mostSpecificMediaType = MediaTypeUtil.getMostSpecificMediaType(msg.getMediaType().toString(), content.keySet()).orElseThrow();
        }
        catch (Exception e) {
            return ValidationErrors.create(ctx.statusCode(this.getStatusCodeForWrongMediaType()).entityType(ValidationContext.ValidatedEntityType.MEDIA_TYPE).entity(msg.getMediaType().toString()), "The media type(Content-Type header) of the %s does not match any of %s.".formatted(this.getMessageName(), content.keySet()));
        }
        return this.validateMediaTypeForMessageType(ctx.statusCode(this.getStatusCodeForWrongMediaType()), mostSpecificMediaType, (MediaType)content.get((Object)mostSpecificMediaType), msg);
    }

    protected abstract int getStatusCodeForWrongMediaType();
}

