/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.CollectionsUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractParameterValidator {
    OpenAPI api;
    PathItem pathItem;

    public AbstractParameterValidator(OpenAPI api, PathItem pathItem) {
        this.api = api;
        this.pathItem = pathItem;
    }

    public Stream<Parameter> getParametersOfType(Operation operation, Class<?> paramClazz) {
        return this.getAllParameterSchemas(operation).stream().filter(p -> this.isTypeOf((Parameter)p, paramClazz));
    }

    public List<Parameter> getAllParameterSchemas(Operation operation) {
        return CollectionsUtil.concat(this.pathItem.getParameters(), operation.getParameters());
    }

    boolean isTypeOf(Parameter p, Class<?> clazz) {
        return p.getClass().equals(clazz);
    }

    public ValidationErrors getValidationErrors(ValidationContext ctx, Map<String, String> parameters, Parameter param, ValidationContext.ValidatedEntityType type) {
        return this.validateParameter(AbstractParameterValidator.getCtx(ctx, param, type), parameters, param, type);
    }

    private static ValidationContext getCtx(ValidationContext ctx, Parameter param, ValidationContext.ValidatedEntityType type) {
        return ctx.entity(param.getName()).entityType(type).statusCode(400);
    }

    public ValidationErrors validateParameter(ValidationContext ctx, Map<String, String> params, Parameter param, ValidationContext.ValidatedEntityType type) {
        ValidationErrors errors = new ValidationErrors();
        String value = params.get(param.getName());
        if (value != null) {
            errors.add(new SchemaValidator(this.api, param.getSchema()).validate(ctx.statusCode(400).entity(param.getName()).entityType(type), value));
        } else if (param.getRequired().booleanValue()) {
            errors.add(ctx, String.format("Missing required %s %s.", type.name, param.getName()));
        }
        return errors;
    }
}

