/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;

public class BooleanValidator
implements IJSONSchemaValidator {
    @Override
    public String canValidate(Object obj) {
        String str = BooleanValidator.getStringValue(obj);
        if (obj instanceof BooleanNode || str.equals("true") || str.equals("false")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object value) {
        ValidationErrors errors = new ValidationErrors();
        if (value instanceof BooleanNode) {
            return errors;
        }
        String str = BooleanValidator.getStringValue(value);
        if (str.equals("true") || str.equals("false")) {
            return errors;
        }
        errors.add(ctx.schemaType("boolean"), String.format("Value '%s' is not a boolean (true/false).", value));
        return errors;
    }

    private static String getStringValue(Object value) {
        if (value instanceof TextNode) {
            TextNode tn = (TextNode)value;
            return tn.asText();
        }
        if (value instanceof String) {
            String s = (String)value;
            return s;
        }
        return "";
    }
}

