/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;

public class IntegerValidator
implements IJSONSchemaValidator {
    @Override
    public String canValidate(Object obj) {
        if (obj instanceof JsonNode) {
            JsonNode j = (JsonNode)obj;
            obj = j.numberValue();
        }
        try {
            if (obj instanceof String) {
                String s = (String)obj;
                Long.parseLong(s);
                return "integer";
            }
            if (obj instanceof Integer) {
                return "integer";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object value) {
        if (value instanceof JsonNode) {
            value = ((JsonNode)value).numberValue();
        }
        try {
            if (value instanceof String) {
                Long.parseLong((String)value);
                return null;
            }
            if (value instanceof Integer) {
                return null;
            }
            if (value instanceof Body) {
                return null;
            }
            if (value != null) {
                throw new RuntimeException("Do not know type " + String.valueOf(value.getClass()));
            }
            throw new RuntimeException("Value is null!");
        }
        catch (NumberFormatException e) {
            return ValidationErrors.create(ctx.schemaType("integer"), String.format("%s is not an integer.", value));
        }
    }
}

