/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;

public class NumberRestrictionValidator {
    private final Schema schema;

    public NumberRestrictionValidator(Schema schema) {
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        BigDecimal value;
        ctx = ctx.schemaType(this.schema.getType());
        if (obj instanceof ObjectNode) {
            return null;
        }
        if (obj instanceof ArrayNode) {
            return null;
        }
        if (obj instanceof BooleanNode) {
            return null;
        }
        try {
            value = Utils.convertToBigDecimal(obj);
        }
        catch (NumberFormatException e) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        errors.add(this.validateMinimum(ctx, value));
        errors.add(this.validateExclusiveMinimum(ctx, value));
        errors.add(this.validateMaximum(ctx, value));
        errors.add(this.validateExclusiveMaximum(ctx, value));
        errors.add(this.validateMultipleOf(ctx, value));
        return errors;
    }

    private ValidationErrors validateMultipleOf(ValidationContext ctx, BigDecimal value) {
        if (this.schema.getMultipleOf() == null) {
            return null;
        }
        BigDecimal multiplesOf = this.schema.getMultipleOf();
        BigDecimal[] remainder = value.divideAndRemainder(multiplesOf);
        if (remainder[1].intValue() != 0) {
            return ValidationErrors.create(ctx, String.format("Value %d is not a multiple of %d.", value.intValue(), multiplesOf.intValue()));
        }
        return null;
    }

    private ValidationErrors validateExclusiveMaximum(ValidationContext ctx, BigDecimal value) {
        if (this.schema.getExclusiveMaximumValue() != null) {
            if (this.schema.getExclusiveMaximumValue().compareTo(value) < 0) {
                return ValidationErrors.create(ctx, String.valueOf(value) + " is greater than the maximum of " + String.valueOf(this.schema.getExclusiveMaximumValue()));
            }
            if (this.schema.getExclusiveMaximumValue().compareTo(value) == 0) {
                return ValidationErrors.create(ctx, String.format("The value of %s should be less than the exclusive maximum %s.", value, this.schema.getExclusiveMaximumValue()));
            }
        }
        return null;
    }

    private ValidationErrors validateMaximum(ValidationContext ctx, BigDecimal value) {
        if (this.schema.getMaximum() != null) {
            if (this.schema.getMaximum().compareTo(value) < 0) {
                return ValidationErrors.create(ctx, String.valueOf(value) + " is greater than the maximum of " + String.valueOf(this.schema.getMaximum()));
            }
            if (this.isExclusiveMaximum() && this.schema.getMaximum().compareTo(value) == 0) {
                return ValidationErrors.create(ctx, String.format("The value of %s should be less than the exclusive maximum %s.", value, this.schema.getMaximum()));
            }
        }
        return null;
    }

    private ValidationErrors validateExclusiveMinimum(ValidationContext ctx, BigDecimal value) {
        if (this.schema.getExclusiveMinimumValue() != null) {
            if (this.schema.getExclusiveMinimumValue().compareTo(value) > 0) {
                return ValidationErrors.create(ctx, String.valueOf(value) + " is smaller than the minimum of " + String.valueOf(this.schema.getExclusiveMinimumValue()));
            }
            if (this.schema.getExclusiveMinimumValue().compareTo(value) == 0) {
                return ValidationErrors.create(ctx, String.format("The value of %s should be greater than the exclusive minimum. %s", value, this.schema.getExclusiveMinimumValue()));
            }
        }
        return null;
    }

    private ValidationErrors validateMinimum(ValidationContext ctx, BigDecimal value) {
        if (this.schema.getMinimum() != null) {
            if (this.schema.getMinimum().compareTo(value) > 0) {
                return ValidationErrors.create(ctx, String.valueOf(value) + " is smaller than the minimum of " + String.valueOf(this.schema.getMinimum()));
            }
            if (this.isExclusiveMinimum() && this.schema.getMinimum().compareTo(value) == 0) {
                return ValidationErrors.create(ctx, String.format("The value of %s should be greater than the exclusive minimum %s.", value, this.schema.getMinimum()));
            }
        }
        return null;
    }

    private boolean isExclusiveMinimum() {
        return this.schema.getExclusiveMinimum() != null && this.schema.getExclusiveMinimum() != false;
    }

    private boolean isExclusiveMaximum() {
        return this.schema.getExclusiveMaximum() != null && this.schema.getExclusiveMaximum() != false;
    }
}

