/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import java.math.BigDecimal;

public class NumberValidator
implements IJSONSchemaValidator {
    @Override
    public String canValidate(Object value) {
        try {
            if (value instanceof Number) {
                return "number";
            }
            if (value instanceof JsonNode) {
                JsonNode jn = (JsonNode)value;
                new BigDecimal(jn.asText());
                return "number";
            }
            if (value instanceof String) {
                String s = (String)value;
                Double.parseDouble(s);
                return "number";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object value) {
        try {
            if (value instanceof JsonNode) {
                JsonNode jn = (JsonNode)value;
                new BigDecimal(jn.asText());
                return null;
            }
            if (value instanceof String) {
                String s = (String)value;
                Double.parseDouble(s);
                return null;
            }
        }
        catch (NumberFormatException ignored) {
            return ValidationErrors.create(ctx.schemaType("number"), String.format("%s is not a number.", value));
        }
        throw new RuntimeException("Should never happen!");
    }
}

