/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectValidator
implements IJSONSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger((String)ObjectValidator.class.getName());
    private Schema schema;
    private JsonNode node;
    private final OpenAPI api;

    public ObjectValidator(OpenAPI api, Schema schema) {
        this.api = api;
        this.schema = schema;
    }

    @Override
    public String canValidate(Object obj) {
        JsonNode j;
        if (!(obj instanceof JsonNode)) {
            if (obj instanceof InputStream) {
                throw new RuntimeException("InputStream should not happen!");
            }
            log.warn("This should not happen. Please check.");
            throw new RuntimeException("Value cannot be read as object.");
        }
        this.node = j = (JsonNode)obj;
        return this.node instanceof ObjectNode ? "object" : null;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        ctx = ctx.schemaType("object");
        if (this.canValidate(obj) == null) {
            return ValidationErrors.create(ctx.statusCode(400), String.format("Value %s is not an object.", this.node));
        }
        ValidationErrors errors = this.validateRequiredProperties(ctx, this.node);
        errors.add(this.validateAddionalProperties(ctx, this.node));
        errors.add(this.validateProperties(ctx, this.node));
        errors.add(this.validateSize(ctx, this.node));
        errors.add(this.validateDiscriminator(ctx, this.node));
        return errors;
    }

    private ValidationErrors validateDiscriminator(ValidationContext ctx, JsonNode node) {
        if (this.schema.getDiscriminator() == null) {
            return null;
        }
        String propertyName = this.schema.getDiscriminator().getPropertyName();
        if (this.schema.getType().equals(propertyName)) {
            return null;
        }
        return new SchemaValidator(this.api, this.getBaseSchema(node, propertyName)).validate(ctx, node);
    }

    private Schema getBaseSchema(JsonNode node, String propertyName) {
        return (Schema)this.api.getComponents().getSchemas().get(this.getBaseSchemaName(node, propertyName));
    }

    private String getBaseSchemaName(JsonNode node, String propertyName) {
        return node.get(propertyName).asText();
    }

    private ValidationErrors validateSize(ValidationContext ctx, JsonNode node) {
        ValidationErrors errors = new ValidationErrors();
        errors.add(this.validateMinProperties(ctx, node));
        errors.add(this.validateMaxProperties(ctx, node));
        return errors;
    }

    private ValidationErrors validateMinProperties(ValidationContext ctx, JsonNode node) {
        if (this.schema.getMinProperties() != null && node.size() < this.schema.getMinProperties()) {
            return ValidationErrors.create(ctx, String.format("Object has %d properties. This is smaller then minProperties of %d.", node.size(), this.schema.getMinProperties()));
        }
        return null;
    }

    private ValidationErrors validateMaxProperties(ValidationContext ctx, JsonNode node) {
        if (this.schema.getMaxProperties() != null && node.size() > this.schema.getMaxProperties()) {
            return ValidationErrors.create(ctx, String.format("Object has %d properties. This is more then maxProperties of %d.", node.size(), this.schema.getMaxProperties()));
        }
        return null;
    }

    private ValidationErrors validateAddionalProperties(ValidationContext ctx, JsonNode node) {
        if (this.schema.getAdditionalProperties() == null) {
            return null;
        }
        Map<String, JsonNode> additionalProperties = this.getAddionalProperties(node);
        if (additionalProperties.size() == 0) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        if (this.schema.getAdditionalProperties() instanceof Schema) {
            additionalProperties.forEach((propName, value) -> errors.add(new SchemaValidator(this.api, (Schema)this.schema.getAdditionalProperties()).validate(ctx.addJSONpointerSegment((String)propName), value)));
            return errors;
        }
        return errors.add(ctx.statusCode(400), String.format("The object has the additional %s: %s .But the schema does not allow additional properties.", this.getPropertyOrIes(additionalProperties.keySet()), Utils.joinByComma(additionalProperties.keySet())));
    }

    private String getPropertyOrIes(Set<String> addionalProperties) {
        String propWord = "Property";
        if (addionalProperties.size() > 1) {
            propWord = "Properties";
        }
        return propWord;
    }

    private Map<String, JsonNode> getAddionalProperties(JsonNode node) {
        HashMap<String, JsonNode> addionalProperties = new HashMap<String, JsonNode>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            if (this.schema.getProperties().containsKey(propName)) continue;
            addionalProperties.put(propName, node.get(propName));
        }
        return addionalProperties;
    }

    private ValidationErrors validateRequiredProperties(ValidationContext ctx, JsonNode node) {
        List required = this.schema.getRequired();
        if (required == null) {
            return new ValidationErrors();
        }
        return this.createErrorsForMissingRequiredProperties(ctx, this.getMissingProperties(ctx, node, required));
    }

    private List<String> getMissingProperties(ValidationContext ctx, JsonNode node, List<String> required) {
        ArrayList<String> missingProperties = new ArrayList<String>();
        required.forEach(requiredProp -> {
            if (node.get(requiredProp) == null) {
                if (ctx.getValidatedEntity().equals("REQUEST") ? this.isPropertyReadOnly((String)requiredProp) : this.isPropertyWriteOnly((String)requiredProp)) {
                    return;
                }
                missingProperties.add((String)requiredProp);
            }
        });
        return missingProperties;
    }

    private boolean isPropertyReadOnly(String propertyName) {
        Schema propSchema = (Schema)this.schema.getProperties().get(propertyName);
        return propSchema.getReadOnly() != null && propSchema.getReadOnly() != false;
    }

    private boolean isPropertyWriteOnly(String propertyName) {
        Schema propSchema = (Schema)this.schema.getProperties().get(propertyName);
        return propSchema.getWriteOnly() != null && propSchema.getWriteOnly() != false;
    }

    private ValidationErrors createErrorsForMissingRequiredProperties(ValidationContext ctx, List<String> missingProperties) {
        ValidationErrors errors = new ValidationErrors();
        if (missingProperties.size() == 1) {
            errors.add(new ValidationError(ctx.addJSONpointerSegment(missingProperties.get(0)), String.format("Required property %s is missing.", missingProperties.get(0))));
        } else if (missingProperties.size() > 1) {
            String missing = String.join((CharSequence)",", missingProperties);
            errors.add(new ValidationError(ctx, String.format("Required properties %s are missing in object %s.", missing, ctx.getJSONpointer())));
        }
        return errors;
    }

    private ValidationErrors validateProperties(ValidationContext ctx, JsonNode node) {
        if (this.schema.getProperties() == null) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        this.getPropertiesFromSchema().forEach((propertyName, propertySchema) -> {
            errors.add(this.validateProperty((String)propertyName, (Schema)propertySchema, node, ctx.addJSONpointerSegment((String)propertyName)));
            errors.add(this.validateReadOnlyProperty(ctx, node, (String)propertyName, (Schema)propertySchema));
            errors.add(this.validateWriteOnlyProperty(ctx, node, (String)propertyName, (Schema)propertySchema));
        });
        return errors;
    }

    private Map<String, Schema> getPropertiesFromSchema() {
        return this.schema.getProperties();
    }

    private ValidationErrors validateReadOnlyProperty(ValidationContext ctx, JsonNode node, String propertyName, Schema propertySchema) {
        if (propertySchema.getReadOnly() == null || !propertySchema.getReadOnly().booleanValue()) {
            return null;
        }
        if (!ctx.getValidatedEntity().equals("REQUEST")) {
            return null;
        }
        if (node.get(propertyName) == null) {
            return null;
        }
        return ValidationErrors.create(ctx.addJSONpointerSegment(propertyName), String.format("The property %s is read only. But the request contains the value %s for this field.", propertyName, node.get(propertyName)));
    }

    private ValidationErrors validateWriteOnlyProperty(ValidationContext ctx, JsonNode node, String propertyName, Schema propertySchema) {
        if (propertySchema.getWriteOnly() == null || !propertySchema.getWriteOnly().booleanValue()) {
            return null;
        }
        if (!ctx.getValidatedEntity().equals("RESPONSE")) {
            return null;
        }
        if (node.get(propertyName) == null) {
            return null;
        }
        return ValidationErrors.create(ctx.addJSONpointerSegment(propertyName), String.format("The property %s is write only. But the response contained the value %s.", propertyName, node.get(propertyName)));
    }

    private ValidationErrors validateProperty(String propertyName, Schema schema, JsonNode node, ValidationContext ctx) {
        ValidationErrors errors = new ValidationErrors();
        if (node.get(propertyName) != null) {
            errors.add(new SchemaValidator(this.api, schema).validate(ctx, node.get(propertyName)));
        }
        return errors;
    }
}

