/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class OneOfValidator {
    private final OpenAPI api;
    private final Schema schema;

    public OneOfValidator(OpenAPI api, Schema schema) {
        this.api = api;
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        List oneOfSchemas = this.schema.getOneOf();
        AtomicInteger numberValid = new AtomicInteger();
        oneOfSchemas.forEach(schema -> {
            if (!Utils.areThereErrors(new SchemaValidator(this.api, (Schema)schema).validate(ctx, obj))) {
                numberValid.incrementAndGet();
            }
        });
        if (numberValid.get() == 1) {
            return null;
        }
        return ValidationErrors.create(ctx, String.format("OneOf requires that exactly one subschema is valid. But there are %d subschemas valid.", numberValid.get()));
    }
}

