/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.model.Response;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIInterceptor;
import com.predic8.membrane.core.openapi.util.MethodNotAllowException;
import com.predic8.membrane.core.openapi.validators.QueryParameterValidator;
import com.predic8.membrane.core.openapi.validators.RequestBodyValidator;
import com.predic8.membrane.core.openapi.validators.RequestHeaderParameterValidator;
import com.predic8.membrane.core.openapi.validators.ResponseBodyValidator;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.SecurityValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.List;

public class OperationValidator {
    OpenAPI api;
    ValidationErrors errors = new ValidationErrors();

    public OperationValidator(OpenAPI api) {
        this.api = api;
    }

    public ValidationErrors validateOperation(ValidationContext ctx, Request<?> req, Response<?> response, PathItem pathItem) throws MethodNotAllowException {
        Operation operation = this.getOperation(req.getMethod(), pathItem);
        if (operation == null) {
            throw new MethodNotAllowException();
        }
        this.isMethodDeclaredInAPI(ctx, req.getMethod(), operation);
        if (response == null) {
            this.validatePathParameters(ctx, req, operation.getParameters());
            this.errors.add(new QueryParameterValidator(this.api, pathItem).validateQueryParameters(ctx, req, operation));
            this.errors.add(new RequestHeaderParameterValidator(this.api, pathItem).validateHeaderParameters(ctx, req, operation));
            if (OpenAPIInterceptor.shouldValidate(this.api, "security")) {
                this.errors.add(new SecurityValidator(this.api).validateSecurity(ctx, req, operation));
            }
            return this.errors.add(new RequestBodyValidator(this.api).validate(ctx.entityType(ValidationContext.ValidatedEntityType.BODY).entity("REQUEST"), req, operation));
        }
        return this.errors.add(new ResponseBodyValidator(this.api).validate(ctx.entityType(ValidationContext.ValidatedEntityType.BODY).entity("RESPONSE"), response, operation));
    }

    private Operation getOperation(String method, PathItem pi) throws MethodNotAllowException {
        return switch (method.toUpperCase()) {
            case "GET" -> pi.getGet();
            case "POST" -> pi.getPost();
            case "PUT" -> pi.getPut();
            case "DELETE" -> pi.getDelete();
            case "PATCH" -> pi.getPatch();
            default -> throw new MethodNotAllowException();
        };
    }

    private void isMethodDeclaredInAPI(ValidationContext ctx, String method, Object apiMethod) {
        if (apiMethod == null) {
            this.errors.add(new ValidationError(ctx.entity(method).entityType(ValidationContext.ValidatedEntityType.METHOD).statusCode(405), String.format("Path %s does not support method %s", ctx.getUriTemplate(), method)));
        }
    }

    private void validatePathParameters(ValidationContext ctx, Request<?> req, List<Parameter> schemaParameters) {
        if (schemaParameters == null || req.getPathParameters().isEmpty()) {
            return;
        }
        schemaParameters.stream().filter(this::isPathParameter).forEach(parameter -> {
            String value = req.getPathParameters().get(parameter.getName());
            if (value == null) {
                throw new RuntimeException("Should not happen!");
            }
            this.errors.add(new SchemaValidator(this.api, parameter.getSchema()).validate(ctx.entityType(ValidationContext.ValidatedEntityType.PATH_PARAMETER).entity(parameter.getName()).path(req.getPath()).statusCode(400), value));
        });
    }

    private boolean isPathParameter(Parameter p) {
        return p instanceof PathParameter;
    }
}

