/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.List;

public class PathParametersValidator {
    OpenAPI api;
    ValidationErrors errors = new ValidationErrors();

    public PathParametersValidator(OpenAPI api) {
        this.api = api;
    }

    public ValidationErrors validatePathParameters(ValidationContext ctx, Request<?> req, List<Parameter> schemaParameters) {
        if (schemaParameters == null || req.getPathParameters().isEmpty()) {
            return null;
        }
        schemaParameters.stream().map(this::resolveRefs).filter(this::isPathParameter).forEach(parameter -> {
            String value = req.getPathParameters().get(parameter.getName());
            if (value == null) {
                throw new RuntimeException("Should not happen! No null for parameter " + String.valueOf(parameter));
            }
            this.errors.add(new SchemaValidator(this.api, parameter.getSchema()).validate(ctx.entityType(ValidationContext.ValidatedEntityType.PATH_PARAMETER).entity(parameter.getName()).path(req.getPath()).statusCode(400), value));
        });
        return this.errors;
    }

    private Parameter resolveRefs(Parameter p) {
        if (p.get$ref() != null && (p = (Parameter)this.api.getComponents().getParameters().get(Utils.getComponentLocalNameFromRef(p.get$ref()))).getSchema().get$ref() != null) {
            p.setSchema((Schema)this.api.getComponents().getSchemas().get(Utils.getComponentLocalNameFromRef(p.getSchema().get$ref())));
        }
        return p;
    }

    private boolean isPathParameter(Parameter p) {
        return p instanceof PathParameter;
    }
}

