/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.validators.AbstractParameterValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryParameterValidator
extends AbstractParameterValidator {
    public QueryParameterValidator(OpenAPI api, PathItem pathItem) {
        super(api, pathItem);
    }

    ValidationErrors validateQueryParameters(ValidationContext ctx, Request<?> request, Operation operation) {
        Map<String, String> queryParams = this.getQueryParams(QueryParameterValidator.getQueryString(request));
        return this.getParametersOfType(operation, QueryParameter.class).map(param -> this.getErrors(ctx, queryParams, (Parameter)param)).reduce(ValidationErrors::add).orElse(new ValidationErrors()).add(this.validateAdditionalQueryParameters(ctx, queryParams, this.api));
    }

    private ValidationErrors getErrors(ValidationContext ctx, Map<String, String> queryParams, Parameter param) {
        ValidationErrors err = this.getValidationErrors(ctx, queryParams, param, ValidationContext.ValidatedEntityType.QUERY_PARAMETER);
        queryParams.remove(param.getName());
        return err;
    }

    private static String getQueryString(Request<?> request) {
        return new URIFactory().createWithoutException(request.getPath()).getQuery();
    }

    private Map<String, String> getQueryParams(String query) {
        if (query != null) {
            return URLParamUtil.parseQueryString(query, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        }
        return new HashMap<String, String>();
    }

    ValidationErrors validateAdditionalQueryParameters(ValidationContext ctx, Map<String, String> qparams, OpenAPI api) {
        this.securitySchemeApiKeyQueryParamNames(api).forEach(qparams::remove);
        if (!qparams.isEmpty()) {
            return ValidationErrors.create(ctx.entityType(ValidationContext.ValidatedEntityType.QUERY_PARAMETER), "There are query parameters that are not supported by the API: " + String.valueOf(qparams.keySet()));
        }
        return ValidationErrors.empty();
    }

    public List<String> securitySchemeApiKeyQueryParamNames(OpenAPI api) {
        if (api.getComponents() == null || api.getComponents().getSecuritySchemes() == null) {
            return Collections.emptyList();
        }
        return api.getComponents().getSecuritySchemes().values().stream().filter(scheme -> scheme != null && scheme.getType() != null && scheme.getType().equals((Object)SecurityScheme.Type.APIKEY) && scheme.getIn().equals((Object)SecurityScheme.In.QUERY)).map(SecurityScheme::getName).toList();
    }
}

