/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.AbstractBodyValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.RequestBody;

public class RequestBodyValidator
extends AbstractBodyValidator<Request<? extends Body>> {
    @Override
    public int getDefaultStatusCode() {
        return 400;
    }

    @Override
    public String getMessageName() {
        return "Request";
    }

    public RequestBodyValidator(OpenAPI api) {
        super(api);
    }

    @Override
    protected int getStatusCodeForWrongMediaType() {
        return 415;
    }

    ValidationErrors validate(ValidationContext ctx, Request<?> request, Operation operation) {
        ValidationErrors errors = new ValidationErrors();
        if (operation.getRequestBody() == null) {
            if (!request.hasBody()) {
                return errors;
            }
            return errors.add(ctx.statusCode(400), "Request has a body although it shouldn't.");
        }
        if (operation.getRequestBody().getContent() != null) {
            errors.add(this.validateBodyInternal(ctx, request, operation.getRequestBody().getContent()));
        } else {
            String ref = operation.getRequestBody().get$ref();
            if (ref != null) {
                errors.add(this.validateBodyInternal(ctx, request, this.getRequestBodyFromSchema(ref).getContent()));
            } else {
                throw new RuntimeException("Should not happen!");
            }
        }
        return errors;
    }

    private RequestBody getRequestBodyFromSchema(String ref) {
        return (RequestBody)this.api.getComponents().getRequestBodies().get(Utils.getComponentLocalNameFromRef(ref));
    }
}

