/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.validators.AbstractParameterValidator;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.HeaderParameter;

public class RequestHeaderParameterValidator
extends AbstractParameterValidator {
    public RequestHeaderParameterValidator(OpenAPI api, PathItem pathItem) {
        super(api, pathItem);
    }

    ValidationErrors validateHeaderParameters(ValidationContext ctx, Request request, Operation operation) {
        return this.getParametersOfType(operation, HeaderParameter.class).map(param -> {
            Message.Headers headers = request.getHeaders();
            String value = null;
            if (headers != null) {
                value = request.getHeaders().get(param.getName());
            }
            if (value != null) {
                if (param.getSchema() != null) {
                    return new SchemaValidator(this.api, param.getSchema()).validate(ctx.statusCode(400).entity(param.getName()).entityType(ValidationContext.ValidatedEntityType.HEADER_PARAMETER), value);
                }
            } else if (param.getRequired().booleanValue()) {
                return ValidationErrors.create(ctx.entity(param.getName()).entityType(ValidationContext.ValidatedEntityType.HEADER_PARAMETER), String.format("Missing required header %s.", param.getName()));
            }
            return new ValidationErrors();
        }).reduce(ValidationErrors::add).orElse(new ValidationErrors());
    }
}

