/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Response;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.AbstractBodyValidator;
import com.predic8.membrane.core.openapi.validators.ResponseHeaderValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.Pair;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseBodyValidator
extends AbstractBodyValidator<Response<?>> {
    @Override
    public int getDefaultStatusCode() {
        return 500;
    }

    @Override
    public String getMessageName() {
        return "Response";
    }

    public ResponseBodyValidator(OpenAPI api) {
        super(api);
    }

    @Override
    protected int getStatusCodeForWrongMediaType() {
        return 500;
    }

    public ValidationErrors validate(ValidationContext ctx, Response<?> response, Operation operation) {
        if (operation.getResponses() == null) {
            throw new RuntimeException("An operation should always have at least one response declared. Please check the OpenAPI document.");
        }
        ctx = ctx.statusCode(500);
        ValidationErrors errors = new ValidationErrors();
        Pair<Boolean, ValidationErrors> vrr = this.findExactMatchingResponseByStatusCodeAndValidate(ctx, operation, response);
        boolean foundMatchingResponse = vrr.first();
        errors.add(vrr.second());
        if (!foundMatchingResponse) {
            Pair<Boolean, ValidationErrors> vr = this.matchStatuscodeWildcardsAndValidate(ctx, operation, response);
            foundMatchingResponse = vr.first();
            errors.add(vr.second());
        }
        if (!foundMatchingResponse && operation.getResponses().get((Object)"default") != null) {
            foundMatchingResponse = true;
            errors.add(this.validateBody(ctx, (ApiResponse)operation.getResponses().get((Object)"default"), response));
        }
        if (!foundMatchingResponse) {
            errors.add(ctx, String.format("Server returned a status code of %d but allowed are only %s", response.getStatusCode(), Utils.joinByComma(operation.getResponses().keySet())));
        }
        return errors;
    }

    private Pair<Boolean, ValidationErrors> matchStatuscodeWildcardsAndValidate(ValidationContext ctx, Operation operation, Response<?> response) {
        AtomicBoolean foundMatchingResponse = new AtomicBoolean();
        ValidationErrors errors = new ValidationErrors();
        operation.getResponses().forEach((statusCode, responseSpec) -> {
            if (!statusCode.endsWith("XX")) {
                return;
            }
            if (!response.matchesWildcard((String)statusCode)) {
                return;
            }
            foundMatchingResponse.set(true);
            errors.add(this.validateBody(ctx, (ApiResponse)responseSpec, response));
        });
        return new Pair<Boolean, ValidationErrors>(foundMatchingResponse.get(), errors);
    }

    private Pair<Boolean, ValidationErrors> findExactMatchingResponseByStatusCodeAndValidate(ValidationContext ctx, Operation operation, Response<?> response) {
        ValidationErrors errors = new ValidationErrors();
        AtomicBoolean foundMatchingResponse = new AtomicBoolean();
        operation.getResponses().forEach((statusCode, responseSpec) -> {
            if (!response.sameStatusCode((String)statusCode)) {
                return;
            }
            foundMatchingResponse.set(true);
            errors.add(new ResponseHeaderValidator(this.api, (ApiResponse)responseSpec).validateHeaders(ctx, response));
            errors.add(this.validateBody(ctx, (ApiResponse)responseSpec, response));
        });
        return new Pair<Boolean, ValidationErrors>(foundMatchingResponse.get(), errors);
    }

    private ValidationErrors validateBody(ValidationContext ctx, ApiResponse responseSpec, Response<?> response) {
        if (responseSpec.getContent() != null) {
            return this.validateBodyInternal(ctx, response, responseSpec.getContent());
        }
        String ref = responseSpec.get$ref();
        if (ref != null) {
            return this.validateBodyInternal(ctx, response, ((ApiResponse)this.api.getComponents().getResponses().get(Utils.getComponentLocalNameFromRef(ref))).getContent());
        }
        if (response.hasBody()) {
            return ValidationErrors.create(ctx, "Response shouldn't have a body. There is no content described in the API specification.");
        }
        return new ValidationErrors();
    }
}

