/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class ResponseHeaderValidator {
    OpenAPI api;
    ApiResponse apiResponse;

    public ResponseHeaderValidator(OpenAPI api, ApiResponse apiResponse) {
        this.api = api;
        this.apiResponse = apiResponse;
    }

    public ValidationErrors validateHeaders(ValidationContext ctx, Message message) {
        if (this.resolveResponseRef(this.apiResponse).getHeaders() == null) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        this.resolveResponseRef(this.apiResponse).getHeaders().forEach((s, headerSpec) -> this.validateHeader(ctx, message, (String)s, (Header)headerSpec, errors));
        return errors;
    }

    private void validateHeader(ValidationContext ctx, Message response, String s, Header headerSpecUnresolved, ValidationErrors errors) {
        Header headerSpec = this.resolveHeaderRef(headerSpecUnresolved);
        Message.Headers headers = response.getHeaders();
        String value = null;
        if (headers != null) {
            value = response.getHeaders().get(s);
        }
        if (value != null) {
            if (headerSpec.getSchema() != null) {
                errors.add(new SchemaValidator(this.api, headerSpec.getSchema()).validate(ctx.statusCode(500).entity(s).entityType(ValidationContext.ValidatedEntityType.HEADER_PARAMETER), value));
            }
        } else if (headerSpec.getRequired() != null && headerSpec.getRequired().booleanValue()) {
            errors.add(ctx.entity(s).entityType(ValidationContext.ValidatedEntityType.HEADER_PARAMETER), String.format("Missing required header %s.", s));
        }
    }

    private Header resolveHeaderRef(Header h) {
        if (h.get$ref() != null) {
            return (Header)this.api.getComponents().getHeaders().get(Utils.getComponentLocalNameFromRef(h.get$ref()));
        }
        return h;
    }

    private ApiResponse resolveResponseRef(ApiResponse p) {
        if (p.get$ref() != null) {
            return (ApiResponse)this.api.getComponents().getResponses().get(Utils.getComponentLocalNameFromRef(p.get$ref()));
        }
        return p;
    }
}

